/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.Entity;
import org.snapscript.core.ModifierType;
import org.snapscript.core.ModifierValidator;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.FunctionBody;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.core.type.TypePart;
import org.snapscript.core.type.TypeState;
import org.snapscript.tree.ModifierList;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.compile.FunctionScopeCompiler;
import org.snapscript.tree.constraint.FunctionName;
import org.snapscript.tree.define.FunctionBodyCompiler;
import org.snapscript.tree.define.MemberFunctionAssembler;
import org.snapscript.tree.define.MemberFunctionBuilder;
import org.snapscript.tree.function.ParameterList;

public class MemberFunction
extends TypePart {
    protected final MemberFunctionAssembler assembler;
    protected final FunctionScopeCompiler compiler;
    protected final ModifierValidator validator;
    protected final AnnotationList annotations;
    protected final FunctionName identifier;
    protected final Statement statement;

    public MemberFunction(AnnotationList annotations, ModifierList modifiers, FunctionName identifier, ParameterList parameters) {
        this(annotations, modifiers, identifier, parameters, null, null);
    }

    public MemberFunction(AnnotationList annotations, ModifierList modifiers, FunctionName identifier, ParameterList parameters, Constraint constraint) {
        this(annotations, modifiers, identifier, parameters, constraint, null);
    }

    public MemberFunction(AnnotationList annotations, ModifierList modifiers, FunctionName identifier, ParameterList parameters, Statement body) {
        this(annotations, modifiers, identifier, parameters, null, body);
    }

    public MemberFunction(AnnotationList annotations, ModifierList modifiers, FunctionName identifier, ParameterList parameters, Constraint constraint, Statement statement) {
        this.assembler = new MemberFunctionAssembler(modifiers, identifier, parameters, constraint, statement);
        this.compiler = new FunctionScopeCompiler(identifier);
        this.validator = new ModifierValidator();
        this.annotations = annotations;
        this.identifier = identifier;
        this.statement = statement;
    }

    @Override
    public TypeState define(TypeBody parent, Type type, Scope scope) throws Exception {
        return this.assemble(parent, type, scope, 0);
    }

    protected TypeState assemble(TypeBody parent, Type type, Scope scope, int mask) throws Exception {
        Scope composite = this.compiler.define(scope, type);
        MemberFunctionBuilder builder = this.assembler.assemble(composite, mask);
        FunctionBody body = builder.create(parent, composite, type);
        Function function = body.create(composite);
        List<Function> functions = type.getFunctions();
        int modifiers = function.getModifiers();
        if (ModifierType.isStatic(modifiers)) {
            Module module = scope.getModule();
            List<Function> list = module.getFunctions();
            list.add(function);
        }
        this.validator.validate((Entity)type, function, modifiers);
        this.annotations.apply(composite, function);
        functions.add(function);
        body.define(composite);
        return new FunctionBodyCompiler(this.identifier, body);
    }
}

