/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.link.FutureExecution;
import org.snapscript.core.module.Module;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.tree.define.ModulePart;

public class ModuleBody
extends Statement {
    private final AtomicReference<Execution> reference = new AtomicReference();
    private final Statement[] statements;
    private final Statement[] executable;
    private final ModulePart[] parts;
    private final AtomicBoolean create;
    private final AtomicBoolean define;

    public ModuleBody(ModulePart ... parts) {
        this.statements = new Statement[parts.length];
        this.executable = new Statement[parts.length];
        this.define = new AtomicBoolean(true);
        this.create = new AtomicBoolean(true);
        this.parts = parts;
    }

    @Override
    public void create(Scope scope) throws Exception {
        if (this.create.compareAndSet(true, false)) {
            Module module = scope.getModule();
            for (int i = 0; i < this.parts.length; ++i) {
                ModulePart part = this.parts[i];
                Statement statement = part.define(this, module);
                statement.create(scope);
                this.statements[i] = statement;
                this.parts[i] = null;
            }
        }
    }

    @Override
    public boolean define(Scope scope) throws Exception {
        if (this.define.compareAndSet(true, false)) {
            for (int i = 0; i < this.statements.length; ++i) {
                Statement statement = this.statements[i];
                if (!statement.define(scope)) continue;
                this.executable[i] = statement;
                this.statements[i] = null;
            }
        }
        return true;
    }

    @Override
    public Execution compile(Scope scope, Constraint returns) throws Exception {
        Execution result = this.reference.get();
        if (result == null) {
            ModuleTask job = new ModuleTask(scope, this.statements, this.executable);
            FutureTask<Execution> task = new FutureTask<Execution>(job);
            FutureExecution execution = new FutureExecution(task, null);
            if (this.reference.compareAndSet(null, execution)) {
                task.run();
                return task.get();
            }
            return this.reference.get();
        }
        return result;
    }

    private class ModuleExecution
    extends Execution {
        private final Execution[] executions;
        private final AtomicBoolean execute = new AtomicBoolean(true);
        private final Scope module;

        public ModuleExecution(Scope module, Execution[] executions) {
            this.executions = executions;
            this.module = module;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Result last = Result.NORMAL;
            if (this.execute.compareAndSet(true, false)) {
                Module parent = this.module.getModule();
                Scope root = parent.getScope();
                for (int i = 0; i < this.executions.length; ++i) {
                    Result result = this.executions[i].execute(root);
                    if (!result.isNormal()) {
                        return result;
                    }
                    last = result;
                }
            }
            return last;
        }
    }

    private class ModuleTask
    implements Callable<Execution> {
        private final Statement[] executable;
        private final Statement[] statements;
        private final Scope module;

        public ModuleTask(Scope module, Statement[] statements, Statement[] executable) {
            this.statements = statements;
            this.executable = executable;
            this.module = module;
        }

        @Override
        public Execution call() throws Exception {
            Statement statement;
            int i;
            Execution[] executions = new Execution[this.statements.length];
            ModuleExecution execution = new ModuleExecution(this.module, executions);
            for (i = 0; i < this.executable.length; ++i) {
                statement = this.executable[i];
                if (statement == null) continue;
                executions[i] = statement.compile(this.module, null);
            }
            for (i = 0; i < this.statements.length; ++i) {
                statement = this.statements[i];
                if (statement == null) continue;
                executions[i] = statement.compile(this.module, null);
            }
            ModuleBody.this.reference.set(execution);
            return execution;
        }
    }
}

