/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Entity;
import org.snapscript.core.Execution;
import org.snapscript.core.ModifierType;
import org.snapscript.core.ModifierValidator;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.property.Property;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.tree.ModifierChecker;
import org.snapscript.tree.ModifierData;
import org.snapscript.tree.ModifierList;
import org.snapscript.tree.define.ModuleBody;
import org.snapscript.tree.define.ModulePart;
import org.snapscript.tree.define.ModuleProperty;

public class ModuleDeclaration
implements Compilation {
    private final ModuleProperty[] properties;
    private final ModifierData modifiers;

    public ModuleDeclaration(ModifierList modifiers, ModuleProperty ... properties) {
        this.modifiers = new ModifierChecker(modifiers);
        this.properties = properties;
    }

    @Override
    public ModulePart compile(Module module, Path path, int line) throws Exception {
        return new CompileResult(this.modifiers, this.properties, module, path, line);
    }

    private static class CompileExecution
    extends Execution {
        private final ModuleProperty[] properties;
        private final ModifierData modifiers;
        private final ModuleBody body;

        public CompileExecution(ModifierData modifiers, ModuleProperty[] properties, ModuleBody body) {
            this.properties = properties;
            this.modifiers = modifiers;
            this.body = body;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Module module = scope.getModule();
            Scope outer = module.getScope();
            int mask = this.modifiers.getModifiers();
            for (ModuleProperty declaration : this.properties) {
                declaration.execute(this.body, outer, mask | ModifierType.STATIC.mask);
            }
            return Result.NORMAL;
        }
    }

    private static class CompileStatement
    extends Statement {
        private final ModuleProperty[] properties;
        private final ModifierValidator validator = new ModifierValidator();
        private final ModifierData modifiers;
        private final ModuleBody body;

        public CompileStatement(ModifierData modifiers, ModuleProperty[] properties, ModuleBody body) {
            this.properties = properties;
            this.modifiers = modifiers;
            this.body = body;
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            Module module = scope.getModule();
            List<Property> list = module.getProperties();
            int mask = this.modifiers.getModifiers();
            for (ModuleProperty declaration : this.properties) {
                Property property = declaration.define(this.body, scope, mask | ModifierType.STATIC.mask);
                this.validator.validate((Entity)module, property, mask | ModifierType.STATIC.mask);
                list.add(property);
            }
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            int mask = this.modifiers.getModifiers();
            for (ModuleProperty declaration : this.properties) {
                declaration.compile(this.body, scope, mask | ModifierType.STATIC.mask);
            }
            return new CompileExecution(this.modifiers, this.properties, this.body);
        }
    }

    private static class CompileResult
    implements ModulePart {
        private final ModuleProperty[] properties;
        private final ModifierData modifiers;
        private final Module module;
        private final Path path;
        private final int line;

        public CompileResult(ModifierData modifiers, ModuleProperty[] properties, Module module, Path path, int line) {
            this.properties = properties;
            this.modifiers = modifiers;
            this.module = module;
            this.path = path;
            this.line = line;
        }

        @Override
        public Statement define(ModuleBody body, Module module) throws Exception {
            Context context = module.getContext();
            ErrorHandler handler = context.getHandler();
            TraceInterceptor interceptor = context.getInterceptor();
            Trace trace = Trace.getNormal(module, this.path, this.line);
            Statement statement = this.create(body);
            return new TraceStatement(interceptor, handler, statement, trace);
        }

        private Statement create(ModuleBody body) throws Exception {
            return new CompileStatement(this.modifiers, this.properties, body);
        }
    }
}

