/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.common.Progress;
import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.type.Phase;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.ModuleBody;
import org.snapscript.tree.define.ModuleBuilder;
import org.snapscript.tree.define.ModuleName;
import org.snapscript.tree.define.ModulePart;

public class ModuleDefinition
implements Compilation {
    private final Statement definition;

    public ModuleDefinition(AnnotationList annotations, ModuleName module, ModulePart ... parts) {
        this.definition = new CompileResult(annotations, module, parts);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getDefine(module, path, line);
        return new TraceStatement(interceptor, handler, this.definition, trace);
    }

    private static class CompileResult
    extends Statement {
        private final AtomicReference<Module> reference;
        private final ModuleBuilder builder;
        private final Statement body;

        public CompileResult(AnnotationList annotations, ModuleName module, ModulePart ... parts) {
            this.builder = new ModuleBuilder(annotations, module);
            this.reference = new AtomicReference();
            this.body = new ModuleBody(parts);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void create(Scope scope) throws Exception {
            Module module = this.builder.create(scope);
            Progress<Phase> progress = module.getProgress();
            Scope inner = module.getScope();
            try {
                this.reference.set(module);
                this.body.create(inner);
            }
            finally {
                progress.done(Phase.CREATE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean define(Scope scope) throws Exception {
            Module module = this.reference.get();
            Progress<Phase> progress = module.getProgress();
            Value value = Value.getTransient(module);
            Scope inner = module.getScope();
            State state = inner.getState();
            try {
                state.addValue("this", value);
                this.body.define(inner);
            }
            finally {
                progress.done(Phase.DEFINE);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            Module module = this.reference.get();
            Progress<Phase> progress = module.getProgress();
            Scope inner = module.getScope();
            Scope local = inner.getStack();
            try {
                Execution execution = this.body.compile(local, null);
                return execution;
            }
            finally {
                progress.done(Phase.COMPILE);
            }
        }
    }
}

