/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import java.util.Set;
import org.snapscript.core.Context;
import org.snapscript.core.ModifierType;
import org.snapscript.core.module.Module;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyValue;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.tree.define.StaticConstantIndexer;

public class StaticConstantCollector {
    private final StaticConstantIndexer indexer = new StaticConstantIndexer("this", "class");

    public void collect(Type type) throws Exception {
        Module module = type.getModule();
        Context context = module.getContext();
        TypeExtractor extractor = context.getExtractor();
        Set<Type> types = extractor.getTypes(type);
        if (!types.isEmpty()) {
            Set<String> names = this.indexer.index(type);
            Scope scope = type.getScope();
            State state = scope.getState();
            for (Type next : types) {
                if (next == type) continue;
                List<Property> properties = next.getProperties();
                for (Property property : properties) {
                    String name = property.getName();
                    int modifiers = property.getModifiers();
                    if (!ModifierType.isStatic(modifiers)) continue;
                    PropertyValue value = new PropertyValue(property, null, name);
                    if (!names.add(name)) continue;
                    state.addValue(name, value);
                }
            }
        }
    }
}

