/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.StaticConstraint;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.index.LocalScopeExtractor;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.ArgumentList;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.define.SuperFunctionHolder;
import org.snapscript.tree.define.SuperInstanceBuilder;

public class SuperInvocation
extends Evaluation {
    private final SuperInstanceBuilder builder;
    private final LocalScopeExtractor extractor = new LocalScopeExtractor(true, false);
    private final SuperFunctionHolder holder;
    private final NameReference reference;
    private final ArgumentList arguments;
    private final Constraint constraint;
    private final Type type;

    public SuperInvocation(Evaluation function, ArgumentList arguments, Type type) {
        this.reference = new NameReference(function);
        this.holder = new SuperFunctionHolder(this.reference, type);
        this.constraint = new StaticConstraint(type);
        this.builder = new SuperInstanceBuilder(type);
        this.arguments = arguments;
        this.type = type;
    }

    @Override
    public Constraint compile(Scope scope, Constraint left) throws Exception {
        Value value = Value.getTransient(this.type);
        FunctionDispatcher dispatcher = this.holder.get(scope, value);
        if (this.arguments != null) {
            Scope outer = scope.getScope();
            Scope compound = this.extractor.extract(scope, outer);
            Type[] list = this.arguments.compile(compound, this.type);
            return dispatcher.compile(scope, this.constraint, list);
        }
        return dispatcher.compile(scope, this.constraint, this.type);
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        Type real = scope.getType();
        Scope instance = this.builder.create(scope, left);
        Value value = Value.getTransient(instance);
        FunctionDispatcher dispatcher = this.holder.get(instance, Value.NULL);
        if (this.arguments != null) {
            Scope outer = real.getScope();
            Scope compound = this.extractor.extract(scope, outer);
            Object[] list = this.arguments.create(compound, real);
            Connection connection = dispatcher.connect(instance, value, list);
            Object result = connection.invoke(instance, value, list);
            return Value.getTransient(result);
        }
        Connection connection = dispatcher.connect(instance, value, real);
        Object result = connection.invoke(instance, value, real);
        return Value.getTransient(result);
    }
}

