/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.InvocationBuilder;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.SignatureAligner;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeState;
import org.snapscript.tree.function.ParameterExtractor;

public class TypeInvocationBuilder
implements InvocationBuilder {
    private ParameterExtractor extractor;
    private SignatureAligner aligner;
    private Invocation invocation;
    private TypeState state;
    private Type type;

    public TypeInvocationBuilder(TypeState state, Signature signature, Type type) {
        this.extractor = new ParameterExtractor(signature);
        this.aligner = new SignatureAligner(signature);
        this.state = state;
        this.type = type;
    }

    @Override
    public void define(Scope scope) throws Exception {
        this.extractor.define(scope);
        this.state.define(scope, this.type);
    }

    @Override
    public void compile(Scope scope) throws Exception {
        this.state.compile(scope, this.type);
    }

    @Override
    public Invocation create(Scope scope) throws Exception {
        if (this.invocation == null) {
            try {
                this.invocation = new ResultConverter(this.state);
            }
            finally {
                this.state.allocate(scope, this.type);
            }
        }
        return this.invocation;
    }

    private class ResultConverter
    implements Invocation<Instance> {
        private final TypeState state;

        public ResultConverter(TypeState state) {
            this.state = state;
        }

        @Override
        public Object invoke(Scope scope, Instance object, Object ... list) throws Exception {
            Type real = (Type)list[0];
            Object[] arguments = TypeInvocationBuilder.this.aligner.align(list);
            Scope inner = TypeInvocationBuilder.this.extractor.extract(object, arguments);
            Result result = this.state.execute(inner, real);
            return result.getValue();
        }
    }
}

