/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Category;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.core.type.TypeState;

public class TypeStateCollector
extends TypeState
implements TypeBody {
    private final List<TypeState> instances;
    private final List<TypeState> statics = new CopyOnWriteArrayList<TypeState>();
    private final List<TypeState> other;
    private final List<TypeState> list;
    private final Category category;

    public TypeStateCollector() {
        this(Category.OTHER);
    }

    public TypeStateCollector(Category category) {
        this.instances = new ArrayList<TypeState>();
        this.other = new ArrayList<TypeState>();
        this.list = new ArrayList<TypeState>();
        this.category = category;
    }

    public void update(TypeState state) throws Exception {
        if (state != null) {
            this.list.add(state);
        }
    }

    @Override
    public Category define(Scope scope, Type type) throws Exception {
        for (TypeState state : this.list) {
            Category category = state.define(scope, type);
            if (category.isStatic()) {
                this.statics.add(state);
                continue;
            }
            if (category.isInstance()) {
                this.instances.add(state);
                continue;
            }
            this.other.add(state);
        }
        if (!this.statics.isEmpty()) {
            return Category.STATIC;
        }
        if (!this.instances.isEmpty()) {
            return Category.INSTANCE;
        }
        return this.category;
    }

    @Override
    public void compile(Scope scope, Type type) throws Exception {
        for (TypeState state : this.statics) {
            state.compile(scope, type);
        }
        for (TypeState state : this.instances) {
            state.compile(scope, type);
        }
        for (TypeState state : this.other) {
            state.compile(scope, type);
        }
    }

    @Override
    public void allocate(Scope scope, Type type) throws Exception {
        for (TypeState state : this.statics) {
            state.allocate(scope, type);
        }
        for (TypeState state : this.other) {
            state.allocate(scope, type);
        }
        this.statics.clear();
    }

    @Override
    public Result execute(Scope scope, Type type) throws Exception {
        Result last = Result.NORMAL;
        for (TypeState state : this.instances) {
            state.execute(scope, type);
        }
        for (TypeState state : this.other) {
            last = state.execute(scope, type);
        }
        return last;
    }
}

