/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.function;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.DeclarationConstraint;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.scope.Scope;
import org.snapscript.tree.Modifier;
import org.snapscript.tree.ModifierChecker;
import org.snapscript.tree.ModifierList;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.annotation.AnnotationList;

public class ParameterDeclaration {
    private DeclarationConstraint constraint;
    private AnnotationList annotations;
    private ModifierChecker checker;
    private NameReference reference;
    private Parameter parameter;
    private Modifier modifier;

    public ParameterDeclaration(AnnotationList annotations, ModifierList modifiers, Evaluation identifier) {
        this(annotations, modifiers, identifier, null, null);
    }

    public ParameterDeclaration(AnnotationList annotations, ModifierList modifiers, Evaluation identifier, Constraint constraint) {
        this(annotations, modifiers, identifier, null, constraint);
    }

    public ParameterDeclaration(AnnotationList annotations, ModifierList modifiers, Evaluation identifier, Modifier modifier) {
        this(annotations, modifiers, identifier, modifier, null);
    }

    public ParameterDeclaration(AnnotationList annotations, ModifierList modifiers, Evaluation identifier, Modifier modifier, Constraint constraint) {
        this.constraint = new DeclarationConstraint(constraint);
        this.reference = new NameReference(identifier);
        this.checker = new ModifierChecker(modifiers);
        this.annotations = annotations;
        this.modifier = modifier;
    }

    public Parameter get(Scope scope) throws Exception {
        if (this.parameter == null) {
            this.parameter = this.create(scope);
            if (this.parameter != null) {
                this.annotations.apply(scope, this.parameter);
            }
        }
        return this.parameter;
    }

    private Parameter create(Scope scope) throws Exception {
        boolean constant = this.checker.isConstant();
        int modifiers = this.checker.getModifiers();
        DeclarationConstraint declare = this.constraint.getConstraint(scope, modifiers);
        String name = this.reference.getName(scope);
        return new Parameter(name, declare, constant, this.modifier != null);
    }
}

