/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.function;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.FunctionSignature;
import org.snapscript.core.function.Origin;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.ParameterBuilder;
import org.snapscript.core.function.Signature;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.tree.function.ParameterDeclaration;
import org.snapscript.tree.function.ParameterMatchChecker;

public class ParameterListCompiler {
    private final ParameterMatchChecker checker;
    private final ParameterDeclaration[] list;
    private final ParameterBuilder builder;

    public ParameterListCompiler(ParameterDeclaration ... list) {
        this.checker = new ParameterMatchChecker(list);
        this.builder = new ParameterBuilder();
        this.list = list;
    }

    public Signature compile(Scope scope, List<Constraint> generics) throws Exception {
        return this.compile(scope, generics, null);
    }

    public Signature compile(Scope scope, List<Constraint> generics, String prefix) throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (prefix != null) {
            Parameter parameter = this.builder.create(Constraint.NONE, prefix);
            parameters.add(parameter);
        }
        Module module = scope.getModule();
        boolean variable = this.checker.isVariable(scope);
        boolean absolute = this.checker.isAbsolute(scope);
        for (int i = 0; i < this.list.length; ++i) {
            ParameterDeclaration declaration = this.list[i];
            if (declaration == null) continue;
            Parameter parameter = declaration.get(scope);
            Constraint constraint = parameter.getConstraint();
            constraint.getType(scope);
            parameters.add(parameter);
        }
        return new FunctionSignature(parameters, generics, module, null, Origin.DEFAULT, absolute, variable);
    }
}

