/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.literal;

import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Constant;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.NumberToken;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.literal.Literal;
import org.snapscript.tree.operation.SignOperator;

public class NumberLiteral
extends Literal {
    private final SignOperator operator;
    private final NumberToken token;

    public NumberLiteral(NumberToken token) {
        this(null, token);
    }

    public NumberLiteral(StringToken sign, NumberToken token) {
        this.operator = SignOperator.resolveOperator(sign);
        this.token = token;
    }

    @Override
    protected Literal.LiteralValue create(Scope scope) throws Exception {
        Number number = this.token.getValue();
        if (number == null) {
            throw new InternalStateException("Number value was null");
        }
        Value value = this.operator.operate(number);
        Number result = (Number)value.getValue();
        return this.create(scope, result);
    }

    private Literal.LiteralValue create(Scope scope, Number result) throws Exception {
        Class<?> type = result.getClass();
        if (type == Integer.class) {
            return new Literal.LiteralValue(result, Constant.INTEGER);
        }
        if (type == Double.class) {
            return new Literal.LiteralValue(result, Constant.DOUBLE);
        }
        if (type == Float.class) {
            return new Literal.LiteralValue(result, Constant.FLOAT);
        }
        if (type == Byte.class) {
            return new Literal.LiteralValue(result, Constant.BYTE);
        }
        if (type == Short.class) {
            return new Literal.LiteralValue(result, Constant.SHORT);
        }
        if (type == Long.class) {
            return new Literal.LiteralValue(result, Constant.LONG);
        }
        return new Literal.LiteralValue(result, Constant.NUMBER);
    }
}

