/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.math;

import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.ValueCache;
import org.snapscript.tree.math.IntegerCalculator;

public class LongCalculator
extends IntegerCalculator {
    @Override
    public Value add(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getLong(first + second);
    }

    @Override
    public Value subtract(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getLong(first - second);
    }

    @Override
    public Value divide(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getLong(first / second);
    }

    @Override
    public Value multiply(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getLong(first * second);
    }

    @Override
    public Value modulus(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getLong(first % second);
    }

    @Override
    public Value shiftLeft(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getDouble(first << (int)second);
    }

    @Override
    public Value shiftRight(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getDouble(first >> (int)second);
    }

    @Override
    public Value unsignedShiftRight(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getDouble(first >>> (int)second);
    }

    @Override
    public Value and(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getDouble(first & second);
    }

    @Override
    public Value or(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getDouble(first | second);
    }

    @Override
    public Value xor(Number left, Number right) {
        long first = left.longValue();
        long second = right.longValue();
        return ValueCache.getDouble(first ^ second);
    }
}

