/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.math;

import org.snapscript.core.variable.Value;
import org.snapscript.tree.math.ByteCalculator;
import org.snapscript.tree.math.DoubleCalculator;
import org.snapscript.tree.math.FloatCalculator;
import org.snapscript.tree.math.IntegerCalculator;
import org.snapscript.tree.math.LongCalculator;
import org.snapscript.tree.math.NumericCalculator;
import org.snapscript.tree.math.ShortCalculator;

public abstract class ValueCalculator
implements NumericCalculator {
    public static final ValueCalculator INTEGER = new IntegerCalculator();
    public static final ValueCalculator LONG = new LongCalculator();
    public static final ValueCalculator FLOAT = new FloatCalculator();
    public static final ValueCalculator DOUBLE = new DoubleCalculator();
    public static final ValueCalculator SHORT = new ShortCalculator();
    public static final ValueCalculator BYTE = new ByteCalculator();

    public Value replace(Value left, Value right) {
        return right;
    }

    public Value coalesce(Value left, Value right) {
        Object primary = left.getValue();
        Object secondary = right.getValue();
        return primary == null ? right : left;
    }

    public Value power(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.power(primary, secondary);
    }

    public Value add(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.add(primary, secondary);
    }

    public Value subtract(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.subtract(primary, secondary);
    }

    public Value divide(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.divide(primary, secondary);
    }

    public Value multiply(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.multiply(primary, secondary);
    }

    public Value modulus(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.modulus(primary, secondary);
    }

    public Value shiftLeft(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.shiftLeft(primary, secondary);
    }

    public Value shiftRight(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.shiftRight(primary, secondary);
    }

    public Value unsignedShiftRight(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.unsignedShiftRight(primary, secondary);
    }

    public Value and(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.and(primary, secondary);
    }

    public Value or(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.or(primary, secondary);
    }

    public Value xor(Value left, Value right) {
        Number primary = left.getNumber();
        Number secondary = right.getNumber();
        return this.xor(primary, secondary);
    }
}

