/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.StringBuilder;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.operation.AssignmentOperator;

public class Assignment
extends Evaluation {
    private final AssignmentOperator operator;
    private final Evaluation left;
    private final Evaluation right;

    public Assignment(Evaluation left, StringToken operator, Evaluation right) {
        this.operator = AssignmentOperator.resolveOperator(operator);
        this.left = left;
        this.right = right;
    }

    @Override
    public void define(Scope scope) throws Exception {
        this.left.define(scope);
        this.right.define(scope);
    }

    @Override
    public Constraint compile(Scope scope, Constraint type) throws Exception {
        Constraint constraint = this.left.compile(scope, type);
        if (constraint.isConstant()) {
            throw new InternalStateException("Illegal modification of constant");
        }
        return this.right.compile(scope, type);
    }

    @Override
    public Value evaluate(Scope scope, Value context) throws Exception {
        Object leftValue;
        Value leftResult = this.left.evaluate(scope, Value.NULL);
        Value rightResult = this.right.evaluate(scope, Value.NULL);
        if (this.operator != AssignmentOperator.EQUAL && !Number.class.isInstance(leftValue = leftResult.getValue())) {
            Object rightValue = rightResult.getValue();
            if (this.operator != AssignmentOperator.PLUS_EQUAL) {
                throw new InternalStateException("Operator " + (Object)((Object)this.operator) + " is illegal");
            }
            String leftText = StringBuilder.create(scope, leftValue);
            String rightText = StringBuilder.create(scope, rightValue);
            String text = leftText.concat(rightText);
            leftResult.setValue(text);
            return leftResult;
        }
        return this.operator.operate(scope, leftResult, rightResult);
    }
}

