/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.StringBuilder;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.math.NumericChecker;
import org.snapscript.tree.math.NumericOperator;

public class CalculationOperation
extends Evaluation {
    private final NumericOperator operator;
    private final Evaluation left;
    private final Evaluation right;

    public CalculationOperation(NumericOperator operator, Evaluation left, Evaluation right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public void define(Scope scope) throws Exception {
        this.left.define(scope);
        this.right.define(scope);
    }

    @Override
    public Constraint compile(Scope scope, Constraint context) throws Exception {
        this.left.compile(scope, null);
        return this.right.compile(scope, null);
    }

    @Override
    public Value evaluate(Scope scope, Value context) throws Exception {
        Object rightValue;
        Object leftValue;
        Value leftResult = this.left.evaluate(scope, Value.NULL);
        Value rightResult = this.right.evaluate(scope, Value.NULL);
        if (this.operator == NumericOperator.PLUS && !NumericChecker.isBothNumeric(leftValue = leftResult.getValue(), rightValue = rightResult.getValue())) {
            String leftText = StringBuilder.create(scope, leftValue);
            String rightText = StringBuilder.create(scope, rightValue);
            String text = leftText.concat(rightText);
            return Value.getTransient(text);
        }
        return this.operator.operate(leftResult, rightResult);
    }
}

