/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import org.snapscript.core.variable.BooleanValue;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.condition.BooleanChecker;
import org.snapscript.tree.math.NumericConverter;

public enum PrefixOperator {
    NOT("!"){

        @Override
        public Value operate(Value right) {
            Object result = right.getValue();
            boolean value = !BooleanChecker.isTrue(result);
            return value ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
    }
    ,
    COMPLEMENT("~"){

        @Override
        public Value operate(Value right) {
            Number value = right.getNumber();
            NumericConverter converter = NumericConverter.resolveConverter(value);
            long number = value.longValue();
            return converter.convert(number ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
    ,
    PLUS("+"){

        @Override
        public Value operate(Value right) {
            Number value = right.getNumber();
            NumericConverter converter = NumericConverter.resolveConverter(value);
            double number = value.doubleValue();
            return converter.convert(number);
        }
    }
    ,
    MINUS("-"){

        @Override
        public Value operate(Value right) {
            Number value = right.getNumber();
            NumericConverter converter = NumericConverter.resolveConverter(value);
            double number = value.doubleValue();
            return converter.convert(-number);
        }
    };

    public final String operator;

    private PrefixOperator(String operator) {
        this.operator = operator;
    }

    public abstract Value operate(Value var1);

    public static PrefixOperator resolveOperator(StringToken token) {
        if (token != null) {
            PrefixOperator[] operators;
            String value = token.getValue();
            for (PrefixOperator operator : operators = PrefixOperator.values()) {
                if (!operator.operator.equals(value)) continue;
                return operator;
            }
        }
        return null;
    }
}

