/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.literal.Literal;
import org.snapscript.tree.literal.NumberLiteral;
import org.snapscript.tree.operation.SignOperator;

public class SignedNumber
extends Literal {
    private SignOperator operator;
    private NumberLiteral literal;

    public SignedNumber(NumberLiteral literal) {
        this(null, literal);
    }

    public SignedNumber(StringToken sign, NumberLiteral literal) {
        this.operator = SignOperator.resolveOperator(sign);
        this.literal = literal;
    }

    @Override
    protected Literal.LiteralValue create(Scope scope) throws Exception {
        Value value = this.literal.evaluate(scope, null);
        Number number = (Number)value.getValue();
        if (number == null) {
            throw new InternalStateException("Number value was null");
        }
        Value result = this.operator.operate(number);
        Constraint constraint = result.getConstraint();
        Number signed = (Number)result.getValue();
        return new Literal.LiteralValue(signed, constraint);
    }
}

