/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.reference;

import java.util.List;
import org.snapscript.core.Entity;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.ConstraintDescription;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public abstract class ConstraintReference
extends Evaluation {
    private volatile ConstraintValue value;

    protected ConstraintReference() {
    }

    @Override
    public Constraint compile(Scope scope, Constraint left) throws Exception {
        if (this.value == null) {
            this.value = this.create(scope);
        }
        return this.value.constraint;
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        if (this.value == null) {
            this.value = this.create(scope);
        }
        return this.value;
    }

    protected abstract ConstraintValue create(Scope var1) throws Exception;

    protected static class ConstraintDefinition
    extends Constraint {
        private ConstraintDescription description;
        private List<Constraint> generics;
        private List<String> imports;
        private Constraint constraint;
        private Type type;
        private String name;

        public ConstraintDefinition(Constraint constraint, Entity entity) {
            this.description = new ConstraintDescription(constraint, entity);
            this.constraint = constraint;
        }

        @Override
        public List<String> getImports(Scope scope) {
            if (this.imports == null) {
                this.imports = this.constraint.getImports(scope);
            }
            return this.imports;
        }

        @Override
        public List<Constraint> getGenerics(Scope scope) {
            if (this.generics == null) {
                this.generics = this.constraint.getGenerics(scope);
            }
            return this.generics;
        }

        @Override
        public Type getType(Scope scope) {
            if (this.type == null) {
                this.type = this.constraint.getType(scope);
            }
            return this.type;
        }

        @Override
        public String getName(Scope scope) {
            if (this.name == null) {
                this.name = this.constraint.getName(scope);
            }
            return this.name;
        }

        public String toString() {
            return this.description.toString();
        }
    }

    protected static class ConstraintValue
    extends Value {
        private final Constraint constraint;
        private final Value value;

        public ConstraintValue(Constraint constraint, Value value, Entity entity) {
            this.constraint = new ConstraintDefinition(constraint, entity);
            this.value = value;
        }

        @Override
        public Constraint getConstraint() {
            return this.constraint;
        }

        @Override
        public <T> T getValue() {
            return this.value.getValue();
        }

        @Override
        public void setValue(Object value) {
            throw new InternalStateException("Illegal modification of literal '" + value + "'");
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

