/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.reference;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.TypeParameterConstraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.constraint.TypeConstraint;
import org.snapscript.tree.reference.GenericArgumentList;
import org.snapscript.tree.reference.TypeReference;

public class GenericDeclaration {
    private final ConstraintCompilation compilation;
    private final GenericArgumentList generics;
    private final TypeReference reference;
    private final Set<String> imports;

    public GenericDeclaration(TypeReference reference, GenericArgumentList generics, TraceInterceptor interceptor, Trace trace) {
        this.compilation = new ConstraintCompilation(reference, generics, interceptor, trace);
        this.imports = new HashSet<String>();
        this.reference = reference;
        this.generics = generics;
    }

    public Value declare(Scope scope) throws Exception {
        List<String> other;
        Module module = scope.getModule();
        Scope outer = module.getScope();
        String name = this.reference.qualify(scope, null);
        if (this.generics != null && (other = this.generics.getImports(scope)) != null) {
            this.imports.addAll(other);
        }
        if (name != null) {
            this.imports.add(name);
        }
        return new ConstraintConstant(this.compilation, outer, this.imports);
    }

    private static class ConstraintEvaluation
    extends Constraint {
        private final Constraint constraint;
        private final List<String> imports;

        public ConstraintEvaluation(Evaluation evaluation, Set<String> imports) {
            this.constraint = new TypeConstraint(evaluation);
            this.imports = new ArrayList<String>(imports);
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public List<String> getImports(Scope scope) {
            return this.imports;
        }

        @Override
        public String getName(Scope scope) {
            return this.constraint.getName(scope);
        }

        @Override
        public List<Constraint> getGenerics(Scope scope) {
            return this.constraint.getGenerics(scope);
        }

        @Override
        public Type getType(Scope scope) {
            return this.constraint.getType(scope);
        }

        public String toString() {
            return String.valueOf(this.constraint);
        }
    }

    private static class ConstraintConstant
    extends Value {
        private final Constraint constraint;
        private final Scope scope;

        public ConstraintConstant(Evaluation evaluation, Scope scope, Set<String> imports) {
            this.constraint = new ConstraintEvaluation(evaluation, imports);
            this.scope = scope;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public Constraint getConstraint() {
            return this.constraint;
        }

        @Override
        public <T> T getValue() {
            return (T)this.constraint.getType(this.scope);
        }

        @Override
        public void setValue(Object value) {
            throw new InternalStateException("Illegal modification of literal '" + value + "'");
        }

        public String toString() {
            return String.valueOf(this.constraint);
        }
    }

    private static class ConstraintCompilation
    extends Evaluation {
        private final TraceInterceptor interceptor;
        private final GenericArgumentList generics;
        private final TypeReference reference;
        private final Trace trace;

        public ConstraintCompilation(TypeReference reference, GenericArgumentList generics, TraceInterceptor interceptor, Trace trace) {
            this.interceptor = interceptor;
            this.reference = reference;
            this.generics = generics;
            this.trace = trace;
        }

        @Override
        public Constraint compile(Scope scope, Constraint left) {
            try {
                Value value = this.reference.evaluate(scope, Value.NULL);
                Object object = value.getValue();
                if (Type.class.isInstance(object)) {
                    List<Constraint> arguments;
                    Constraint constraint = value.getConstraint();
                    String name = constraint.getName(scope);
                    Type type = constraint.getType(scope);
                    if (this.generics != null && !(arguments = this.generics.getGenerics(scope)).isEmpty()) {
                        return new TypeParameterConstraint(type, arguments, name);
                    }
                    return new TypeParameterConstraint(type, name);
                }
                return value.getConstraint();
            }
            catch (Exception cause) {
                this.interceptor.traceCompileError(scope, this.trace, cause);
                return Constraint.OBJECT;
            }
        }
    }
}

