/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.reference;

import org.snapscript.core.Compilation;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.reference.ReferenceOperator;

public class ReferenceNavigation
implements Compilation {
    private final StringToken operator;
    private final Evaluation part;
    private final Evaluation next;

    public ReferenceNavigation(Evaluation part) {
        this(part, null, null);
    }

    public ReferenceNavigation(Evaluation part, StringToken operator, Evaluation next) {
        this.operator = operator;
        this.part = part;
        this.next = next;
    }

    @Override
    public Object compile(Module module, Path path, int line) throws Exception {
        if (this.next != null) {
            return new CompileResult(this.part, this.operator, this.next);
        }
        return this.part;
    }

    private static class CompileResult
    extends Evaluation {
        private final ReferenceOperator operator;
        private final Evaluation part;
        private final Evaluation next;

        public CompileResult(Evaluation part, StringToken operator, Evaluation next) {
            this.operator = ReferenceOperator.resolveOperator(operator);
            this.part = part;
            this.next = next;
        }

        @Override
        public void define(Scope scope) throws Exception {
            this.next.define(scope);
            this.part.define(scope);
        }

        @Override
        public Constraint compile(Scope scope, Constraint left) throws Exception {
            Constraint value = this.part.compile(scope, left);
            if (this.operator == ReferenceOperator.FORCE) {
                return this.next.compile(scope, Constraint.NONE);
            }
            if (value != null) {
                return this.next.compile(scope, value);
            }
            return value;
        }

        @Override
        public Value evaluate(Scope scope, Value left) throws Exception {
            Value value = this.part.evaluate(scope, left);
            if (this.operator != null) {
                return this.operator.operate(scope, this.next, value);
            }
            return value;
        }
    }
}

