/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.reference;

import org.snapscript.core.Evaluation;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;

public enum ReferenceOperator {
    NORMAL("."){

        @Override
        public Value operate(Scope scope, Evaluation next, Value value) throws Exception {
            Object object = value.getValue();
            if (object != null) {
                return next.evaluate(scope, value);
            }
            throw new NullPointerException("Reference to a null object");
        }
    }
    ,
    FORCE("!."){

        @Override
        public Value operate(Scope scope, Evaluation next, Value value) throws Exception {
            Object object = value.getValue();
            if (object != null) {
                return next.evaluate(scope, value);
            }
            throw new NullPointerException("Reference to a null object");
        }
    }
    ,
    EXISTENTIAL("?."){

        @Override
        public Value operate(Scope scope, Evaluation next, Value value) throws Exception {
            Object object = value.getValue();
            if (object != null) {
                return next.evaluate(scope, value);
            }
            return Value.getTransient(object);
        }
    };

    private final String symbol;

    private ReferenceOperator(String symbol) {
        this.symbol = symbol;
    }

    public abstract Value operate(Scope var1, Evaluation var2, Value var3) throws Exception;

    public static ReferenceOperator resolveOperator(StringToken token) {
        if (token != null) {
            ReferenceOperator[] operators;
            String value = token.getValue();
            for (ReferenceOperator operator : operators = ReferenceOperator.values()) {
                if (!operator.symbol.equals(value)) continue;
                return operator;
            }
        }
        return null;
    }
}

