/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.reference;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.error.Reason;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableBinder;
import org.snapscript.tree.ModifierAccessVerifier;
import org.snapscript.tree.NameReference;

public class ReferenceProperty
implements Compilation {
    private final Evaluation[] evaluations;
    private final NameReference reference;

    public ReferenceProperty(Evaluation identifier, Evaluation ... evaluations) {
        this.reference = new NameReference(identifier);
        this.evaluations = evaluations;
    }

    @Override
    public Evaluation compile(Module module, Path path, int line) throws Exception {
        Scope scope = module.getScope();
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        ProxyWrapper wrapper = context.getWrapper();
        String name = this.reference.getName(scope);
        return new CompileResult(handler, wrapper, this.evaluations, name);
    }

    private static class CompileResult
    extends Evaluation {
        private final ModifierAccessVerifier verifier;
        private final Evaluation[] evaluations;
        private final VariableBinder binder;
        private final ErrorHandler handler;
        private final String name;

        public CompileResult(ErrorHandler handler, ProxyWrapper wrapper, Evaluation[] evaluations, String name) {
            this.binder = new VariableBinder(handler, wrapper, name);
            this.verifier = new ModifierAccessVerifier();
            this.evaluations = evaluations;
            this.handler = handler;
            this.name = name;
        }

        @Override
        public Constraint compile(Scope scope, Constraint left) throws Exception {
            Type type;
            Constraint result = this.binder.compile(scope, left);
            if (result.isPrivate() && !this.verifier.isAccessible(scope, type = left.getType(scope))) {
                this.handler.handleCompileError(Reason.ACCESS, scope, type, this.name);
            }
            for (Evaluation evaluation : this.evaluations) {
                if (result == null) {
                    throw new InternalStateException("Result of '" + this.name + "' is null");
                }
                result = evaluation.compile(scope, result);
            }
            return result;
        }

        @Override
        public Value evaluate(Scope scope, Value left) throws Exception {
            Value value = this.binder.bind(scope, left);
            for (Evaluation evaluation : this.evaluations) {
                Object result = value.getValue();
                if (result == null) {
                    throw new InternalStateException("Result of '" + this.name + "' is null");
                }
                value = evaluation.evaluate(scope, value);
            }
            return value;
        }
    }
}

