/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.reference;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Entity;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.reference.TypeNavigation;
import org.snapscript.tree.reference.TypeReferenceWrapper;

public class TypeReferencePart
implements Compilation {
    private final NameReference reference;

    public TypeReferencePart(Evaluation type) {
        this.reference = new NameReference(type);
    }

    @Override
    public Evaluation compile(Module module, Path path, int line) throws Exception {
        Scope scope = module.getScope();
        Context context = module.getContext();
        TypeExtractor extractor = context.getExtractor();
        String name = this.reference.getName(scope);
        return new CompileResult(extractor, module, name);
    }

    private static class CompileResult
    extends TypeNavigation {
        private final TypeReferenceWrapper mapper = new TypeReferenceWrapper();
        private final TypeExtractor extractor;
        private final Module source;
        private final String name;

        public CompileResult(TypeExtractor extractor, Module source, String name) {
            this.extractor = extractor;
            this.source = source;
            this.name = name;
        }

        @Override
        public String qualify(Scope scope, String left) throws Exception {
            if (left != null) {
                return left + '$' + this.name;
            }
            return this.name;
        }

        @Override
        public Value evaluate(Scope scope, Value left) throws Exception {
            Object object = left.getValue();
            if (object != null) {
                if (Module.class.isInstance(object)) {
                    return this.create(scope, (Module)object);
                }
                if (Type.class.isInstance(object)) {
                    return this.create(scope, (Type)object);
                }
                throw new InternalStateException("No type found for '" + this.name + "' in '" + this.source + "'");
            }
            return this.create(scope);
        }

        private Value create(Scope scope) throws Exception {
            Module parent = scope.getModule();
            Entity result = parent.getType(this.name);
            Type type = scope.getType();
            if (result == null) {
                result = this.source.getModule(this.name);
            }
            if (result == null && type != null) {
                result = this.extractor.getType(type, this.name);
            }
            if (result == null) {
                State state = scope.getState();
                Constraint constraint = state.getConstraint(this.name);
                if (constraint == null) {
                    throw new InternalStateException("No type found for '" + this.name + "' in '" + this.source + "'");
                }
                return this.mapper.toValue(scope, constraint, this.name);
            }
            return this.mapper.toValue(scope, result, this.name);
        }

        private Value create(Scope scope, Module module) throws Exception {
            Type result = module.getType(this.name);
            if (result == null) {
                throw new InternalStateException("No type found for '" + this.name + "' in '" + module + "'");
            }
            return this.mapper.toValue(scope, result, this.name);
        }

        private Value create(Scope scope, Type type) throws Exception {
            String parent;
            Module module = type.getModule();
            Type result = module.getType((parent = type.getName()) + "$" + this.name);
            if (result == null) {
                throw new InternalStateException("No type found for '" + parent + "." + this.name + "' in '" + module + "'");
            }
            return this.mapper.toValue(scope, result, parent + "$" + this.name);
        }
    }
}

