/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.script;

import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;

public class Script
extends Statement {
    private final Statement[] statements;
    private final Statement[] executable;

    public Script(Statement ... statements) {
        this.executable = new Statement[statements.length];
        this.statements = statements;
    }

    @Override
    public void create(Scope scope) throws Exception {
        for (Statement statement : this.statements) {
            statement.create(scope);
        }
    }

    @Override
    public boolean define(Scope scope) throws Exception {
        for (int i = 0; i < this.statements.length; ++i) {
            Statement statement = this.statements[i];
            if (!statement.define(scope)) continue;
            this.executable[i] = statement;
            this.statements[i] = null;
        }
        return true;
    }

    @Override
    public Execution compile(Scope scope, Constraint returns) throws Exception {
        Statement statement;
        int i;
        Execution[] executions = new Execution[this.statements.length];
        for (i = 0; i < this.executable.length; ++i) {
            statement = this.executable[i];
            if (statement == null) continue;
            executions[i] = statement.compile(scope, null);
        }
        for (i = 0; i < this.statements.length; ++i) {
            statement = this.statements[i];
            if (statement == null) continue;
            executions[i] = statement.compile(scope, null);
        }
        return new ScriptExecution(executions);
    }

    private static class ScriptExecution
    extends Execution {
        private final Execution[] executions;

        public ScriptExecution(Execution ... executions) {
            this.executions = executions;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Result last = Result.NORMAL;
            for (Execution statement : this.executions) {
                Result result = statement.execute(scope);
                if (!result.isNormal()) {
                    throw new InternalStateException("Illegal statement");
                }
                last = result;
            }
            return last;
        }
    }
}

