/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.script;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Execution;
import org.snapscript.core.NoExecution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.DeclarationConstraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.FunctionBody;
import org.snapscript.core.function.Signature;
import org.snapscript.core.module.Module;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.tree.compile.FunctionScopeCompiler;
import org.snapscript.tree.constraint.FunctionName;
import org.snapscript.tree.function.FunctionBuilder;
import org.snapscript.tree.function.ParameterList;
import org.snapscript.tree.script.ScriptFunctionBuilder;

public class ScriptFunction
extends Statement {
    private final AtomicReference<FunctionBody> reference = new AtomicReference();
    private final FunctionScopeCompiler compiler;
    private final ParameterList parameters;
    private final FunctionBuilder builder;
    private final FunctionName identifier;
    private final Constraint constraint;
    private final Execution execution;

    public ScriptFunction(FunctionName identifier, ParameterList parameters, Statement body) {
        this(identifier, parameters, null, body);
    }

    public ScriptFunction(FunctionName identifier, ParameterList parameters, Constraint constraint, Statement body) {
        this.constraint = new DeclarationConstraint(constraint);
        this.compiler = new FunctionScopeCompiler(identifier);
        this.builder = new ScriptFunctionBuilder(body);
        this.execution = new NoExecution(Result.NORMAL);
        this.identifier = identifier;
        this.parameters = parameters;
    }

    @Override
    public boolean define(Scope scope) throws Exception {
        Module module = scope.getModule();
        String name = this.identifier.getName(scope);
        Scope combined = this.compiler.define(scope, null);
        List<Function> functions = module.getFunctions();
        List<Constraint> generics = this.identifier.getGenerics(combined);
        Signature signature = this.parameters.create(combined, generics);
        FunctionBody body = this.builder.create(signature, module, this.constraint, name);
        Function function = body.create(combined);
        functions.add(function);
        body.define(combined);
        this.reference.set(body);
        return false;
    }

    @Override
    public Execution compile(Scope scope, Constraint returns) throws Exception {
        FunctionBody body = this.reference.get();
        String name = this.identifier.getName(scope);
        if (body == null) {
            throw new InternalStateException("Function '" + name + "' was not compiled");
        }
        Function function = body.create(scope);
        Scope combined = this.compiler.compile(scope, null, function);
        body.compile(combined);
        return this.execution;
    }
}

