/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.script;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.link.FutureExecution;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;

public class ScriptPackage
extends Statement {
    private final AtomicReference<Execution> reference = new AtomicReference();
    private final Statement[] statements;
    private final AtomicBoolean create = new AtomicBoolean(true);
    private final AtomicBoolean define = new AtomicBoolean(true);

    public ScriptPackage(Statement ... statements) {
        this.statements = statements;
    }

    @Override
    public void create(Scope scope) throws Exception {
        if (this.create.compareAndSet(true, false)) {
            for (Statement statement : this.statements) {
                statement.create(scope);
            }
        }
    }

    @Override
    public boolean define(Scope scope) throws Exception {
        if (this.define.compareAndSet(true, false)) {
            for (Statement statement : this.statements) {
                statement.define(scope);
            }
        }
        return true;
    }

    @Override
    public Execution compile(Scope scope, Constraint returns) throws Exception {
        Execution result = this.reference.get();
        if (result == null) {
            ScriptPackageTask job = new ScriptPackageTask(this.reference, scope, this.statements);
            FutureTask<Execution> task = new FutureTask<Execution>(job);
            FutureExecution execution = new FutureExecution(task, null);
            if (this.reference.compareAndSet(null, execution)) {
                task.run();
                return task.get();
            }
            return this.reference.get();
        }
        return result;
    }

    private static class ScriptPackageExecution
    extends Execution {
        private final Execution[] statements;
        private final AtomicBoolean execute = new AtomicBoolean(true);

        public ScriptPackageExecution(Execution ... statements) {
            this.statements = statements;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Result last = Result.NORMAL;
            if (this.execute.compareAndSet(true, false)) {
                for (int i = 0; i < this.statements.length; ++i) {
                    Result result = this.statements[i].execute(scope);
                    if (!result.isNormal()) {
                        throw new InternalStateException("Illegal statement");
                    }
                    this.statements[i] = null;
                    last = result;
                }
            }
            return last;
        }
    }

    private static class ScriptPackageTask
    implements Callable<Execution> {
        private final AtomicReference<Execution> reference;
        private final Statement[] statements;
        private final Scope scope;

        public ScriptPackageTask(AtomicReference<Execution> reference, Scope scope, Statement ... statements) {
            this.reference = reference;
            this.statements = statements;
            this.scope = scope;
        }

        @Override
        public Execution call() throws Exception {
            Execution[] executions = new Execution[this.statements.length];
            ScriptPackageExecution execution = new ScriptPackageExecution(executions);
            for (int i = 0; i < this.statements.length; ++i) {
                executions[i] = this.statements[i].compile(this.scope, null);
                this.statements[i] = null;
            }
            this.reference.set(execution);
            return execution;
        }
    }
}

