/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.template;

import java.io.Writer;
import org.snapscript.core.ExpressionEvaluator;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.tree.template.Segment;

public class ExpressionSegment
implements Segment {
    private final ExpressionEvaluator evaluator;
    private final ProxyWrapper wrapper;
    private final String expression;

    public ExpressionSegment(ExpressionEvaluator evaluator, ProxyWrapper wrapper, char[] source, int off, int length) {
        this.expression = new String(source, off + 2, length - 3);
        this.evaluator = evaluator;
        this.wrapper = wrapper;
    }

    @Override
    public void process(Scope scope, Writer writer) throws Exception {
        Module module = scope.getModule();
        String name = module.getName();
        Object value = this.evaluator.evaluate(scope, this.expression, name);
        if (value == null) {
            writer.write("null");
        } else {
            Object object = this.wrapper.toProxy(value);
            String text = String.valueOf(object);
            writer.append(text);
        }
    }

    public String toString() {
        return this.expression;
    }
}

