/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.template;

import org.snapscript.core.ExpressionEvaluator;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.tree.template.ExpressionSegment;
import org.snapscript.tree.template.Segment;
import org.snapscript.tree.template.TextSegment;
import org.snapscript.tree.template.VariableSegment;

public class SegmentIterator {
    private static final short[] IDENTIFIER = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private ExpressionEvaluator evaluator;
    private ProxyWrapper wrapper;
    private char[] source;
    private int off;

    public SegmentIterator(ExpressionEvaluator evaluator, ProxyWrapper wrapper, char[] source) {
        this.evaluator = evaluator;
        this.wrapper = wrapper;
        this.source = source;
    }

    public Segment next() {
        int mark = this.off;
        while (this.off < this.source.length) {
            char next = this.source[this.off];
            if (next == '$') {
                if (this.off > mark) {
                    return new TextSegment(this.source, mark, this.off - mark);
                }
            } else if (this.off > 0) {
                char prev = this.source[this.off - 1];
                if (next == '{' && prev == '$') {
                    int start = this.off + 1;
                    int special = 0;
                    while (this.off < this.source.length) {
                        char symbol;
                        if ((symbol = this.source[this.off++]) == '}') {
                            if (special > 0) {
                                return new ExpressionSegment(this.evaluator, this.wrapper, this.source, mark, this.off - mark);
                            }
                            return new VariableSegment(this.wrapper, this.source, mark, this.off - mark);
                        }
                        if (this.off <= start) continue;
                        if (IDENTIFIER.length < symbol) {
                            ++special;
                            continue;
                        }
                        if (IDENTIFIER[symbol] != 0) continue;
                        ++special;
                    }
                    return new TextSegment(this.source, mark, this.off - mark);
                }
            }
            ++this.off;
        }
        if (this.off > mark) {
            return new TextSegment(this.source, mark, this.off - mark);
        }
        return null;
    }

    public boolean hasNext() {
        return this.off < this.source.length;
    }
}

