/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.template;

import java.io.Writer;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableFinder;
import org.snapscript.core.variable.index.LocalPointer;
import org.snapscript.core.variable.index.VariablePointer;
import org.snapscript.tree.template.Segment;

public class VariableSegment
implements Segment {
    private final VariablePointer pointer;
    private final VariableFinder finder;
    private final ProxyWrapper wrapper;
    private final String variable;

    public VariableSegment(ProxyWrapper wrapper, char[] source, int off, int length) {
        this.variable = new String(source, off + 2, length - 3);
        this.finder = new VariableFinder(wrapper);
        this.pointer = new LocalPointer(this.finder, this.variable);
        this.wrapper = wrapper;
    }

    @Override
    public void process(Scope scope, Writer writer) throws Exception {
        Value value = this.pointer.getValue(scope, null);
        if (value == null) {
            throw new InternalStateException("Variable '" + this.variable + "' not found");
        }
        Object token = value.getValue();
        Object object = this.wrapper.toProxy(token);
        String text = String.valueOf(object);
        writer.append(text);
    }

    public String toString() {
        return this.variable;
    }
}

