/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.variable;

import org.snapscript.core.Compilation;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;

public class VariableReference
implements Compilation {
    private final Evaluation[] evaluations;
    private final Evaluation variable;

    public VariableReference(Evaluation variable, Evaluation ... evaluations) {
        this.evaluations = evaluations;
        this.variable = variable;
    }

    @Override
    public Evaluation compile(Module module, Path path, int line) throws Exception {
        if (this.evaluations.length > 0) {
            return new CompileResult(this.variable, this.evaluations);
        }
        return this.variable;
    }

    private static class CompileResult
    extends Evaluation {
        private final Evaluation[] evaluations;
        private final Evaluation variable;

        public CompileResult(Evaluation variable, Evaluation ... evaluations) {
            this.evaluations = evaluations;
            this.variable = variable;
        }

        @Override
        public void define(Scope scope) throws Exception {
            this.variable.define(scope);
            for (Evaluation evaluation : this.evaluations) {
                evaluation.define(scope);
            }
        }

        @Override
        public Constraint compile(Scope scope, Constraint left) throws Exception {
            Constraint result = this.variable.compile(scope, left);
            for (Evaluation evaluation : this.evaluations) {
                if (result == null) {
                    throw new InternalStateException("Result of evaluation is null");
                }
                result = evaluation.compile(scope, result);
            }
            return result;
        }

        @Override
        public Value evaluate(Scope scope, Value left) throws Exception {
            Value value = this.variable.evaluate(scope, left);
            for (Evaluation evaluation : this.evaluations) {
                Object result = value.getValue();
                if (result == null) {
                    throw new InternalStateException("Result of evaluation is null");
                }
                value = evaluation.evaluate(scope, value);
            }
            return value;
        }
    }
}

