/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.snapscript.dx.dex.code.form;

import org.snapscript.dx.dex.code.DalvInsn;
import org.snapscript.dx.dex.code.InsnFormat;
import org.snapscript.dx.util.AnnotatedOutput;

/**
 * Instruction format for nonstandard format instructions, which aren't
 * generally real instructions but do end up appearing in instruction
 * lists. Most of the overridden methods on this class end up throwing
 * exceptions, as code should know (implicitly or explicitly) to avoid
 * using this class. The one exception is {@link #isCompatible}, which
 * always returns {@code true}.
 */
public final class SpecialFormat extends InsnFormat {
    /** {@code non-null;} unique instance of this class */
    public static final InsnFormat THE_ONE = new SpecialFormat();

    /**
     * Constructs an instance. This class is not publicly
     * instantiable. Use {@link #THE_ONE}.
     */
    private SpecialFormat() {
        // This space intentionally left blank.
    }

    /** {@inheritDoc} */
    @Override
    public String insnArgString(DalvInsn insn) {
        throw new RuntimeException("unsupported");
    }

    /** {@inheritDoc} */
    @Override
    public String insnCommentString(DalvInsn insn, boolean noteIndices) {
        throw new RuntimeException("unsupported");
    }

    /** {@inheritDoc} */
    @Override
    public int codeSize() {
        throw new RuntimeException("unsupported");
    }

    /** {@inheritDoc} */
    @Override
    public boolean isCompatible(DalvInsn insn) {
        return true;
    }

    /** {@inheritDoc} */
    @Override
    public void writeTo(AnnotatedOutput out, DalvInsn insn) {
        throw new RuntimeException("unsupported");
    }
}