/*******************************************************************************
 * Copyright (c) 2017, 2020 Sebastian Palarus
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     Sebastian Palarus - initial API and implementation
 *******************************************************************************/
package org.sodeac.common.message.dispatcher.api;

import java.util.UUID;
/**
 *  API for a special scope in channels.
 *  
 * @author Sebastian Palarus
 *
 */
public interface ISubChannel<T> extends IDispatcherChannel<T>
{
	
	/**
	 * getter for scope id. ScopeId is unique key (by global session) addressed this scope
	 * 
	 * @return scope id
	 */
	public UUID getScopeId();
	
	/**
	 * dispose this scope and remove it from global scope
	 */
	public void dispose();
	
}
