/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.BomCharacterChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import java.io.File;
import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.sonar.api.batch.AbstractCpdMapping;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.resources.Language;
import org.sonar.plugins.csharp.CSharp;
import org.sonar.sslr.channel.Channel;

public class CSharpCPDMapping
extends AbstractCpdMapping {
    private static final String INT_SUFFIX = "(((U|u)(L|l)?)|((L|l)(u|U)?))";
    private static final String REAL_SUFFIX = "(F|f|D|d|M|m)";
    private static final String EXP = RegexpChannelBuilder.g((String[])new String[]{"[Ee]" + RegexpChannelBuilder.opt((String)"[+-]") + RegexpChannelBuilder.one2n((String)"\\d")});
    private static final String LETTER_CHAR = RegexpChannelBuilder.g((String[])new String[]{"\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}"});
    private static final String COMBINING_CHAR = RegexpChannelBuilder.g((String[])new String[]{"\\p{Mn}|\\p{Mc}"});
    private static final String DECIMAL_DIGIT_CHAR = RegexpChannelBuilder.g((String[])new String[]{"\\p{Nd}"});
    private static final String CONNECTING_CHAR = RegexpChannelBuilder.g((String[])new String[]{"\\p{Pc}"});
    private static final String FORMATTING_CHAR = RegexpChannelBuilder.g((String[])new String[]{"\\p{Cf}"});
    private final CSharp csharp;
    private final Lexer lexer;

    public CSharpCPDMapping(CSharp csharp, FileSystem fs) {
        this.csharp = csharp;
        this.lexer = Lexer.builder().withCharset(fs.encoding()).withFailIfNoChannelToConsumeOneCharacter(true).withChannel((Channel)RegexpChannelBuilder.commentRegexp((String[])new String[]{"//", RegexpChannelBuilder.o2n((String)"[^\\n\\r]")})).withChannel((Channel)RegexpChannelBuilder.commentRegexp((String[])new String[]{"/\\*", "[\\s\\S]*?", "\\*/"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.LITERAL, (String[])new String[]{"\"", RegexpChannelBuilder.o2n((String)RegexpChannelBuilder.or((String[])new String[]{"\\\\.", RegexpChannelBuilder.anyButNot((String[])new String[]{"\"", "\\n", "\\r"})})), "\""})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.LITERAL, (String[])new String[]{"@\"", RegexpChannelBuilder.o2n((String)RegexpChannelBuilder.or((String[])new String[]{"\"\"", RegexpChannelBuilder.anyButNot((String[])new String[]{"\""})})), "\""})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.IDENTIFIER, (String[])new String[]{"'", RegexpChannelBuilder.one2n((String)RegexpChannelBuilder.or((String[])new String[]{"\\\\.", RegexpChannelBuilder.anyButNot((String[])new String[]{"'", "\\n", "\\r"})})), "'"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.IDENTIFIER, (String[])new String[]{RegexpChannelBuilder.o2n((String)"\\d"), "\\.", RegexpChannelBuilder.one2n((String)"\\d"), RegexpChannelBuilder.opt((String)EXP), RegexpChannelBuilder.opt((String)REAL_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.IDENTIFIER, (String[])new String[]{RegexpChannelBuilder.one2n((String)"\\d"), EXP, RegexpChannelBuilder.opt((String)REAL_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.IDENTIFIER, (String[])new String[]{RegexpChannelBuilder.one2n((String)"\\d"), REAL_SUFFIX})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.IDENTIFIER, (String[])new String[]{"0[xX]", RegexpChannelBuilder.one2n((String)"[a-fA-F0-9]"), RegexpChannelBuilder.opt((String)INT_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.IDENTIFIER, (String[])new String[]{RegexpChannelBuilder.one2n((String)"\\d"), RegexpChannelBuilder.opt((String)INT_SUFFIX)})).withChannel((Channel)new IdentifierAndKeywordChannel(RegexpChannelBuilder.g((String[])new String[]{RegexpChannelBuilder.opt((String)"@"), RegexpChannelBuilder.or((String[])new String[]{LETTER_CHAR, "_"}), RegexpChannelBuilder.o2n((String)RegexpChannelBuilder.or((String[])new String[]{LETTER_CHAR, DECIMAL_DIGIT_CHAR, CONNECTING_CHAR, COMBINING_CHAR, FORMATTING_CHAR}))}), true, (TokenType[][])new TokenType[0][])).withChannel((Channel)new PunctuatorChannel((TokenType[])CSharpPunctuator.values())).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.IDENTIFIER, (String[])new String[]{"#[^\\r\\n]*"})).withChannel((Channel)new BlackHoleChannel("\\s++")).withChannel((Channel)new BomCharacterChannel()).withChannel((Channel)new UnknownCharacterChannel()).build();
    }

    public Language getLanguage() {
        return this.csharp;
    }

    public Tokenizer getTokenizer() {
        return new Tokenizer(){

            public void tokenize(SourceCode source, Tokens cpdTokens) {
                String fileName = source.getFileName();
                List<Token> tokens = CSharpCPDMapping.this.lexer.lex(new File(fileName));
                tokens = this.removeUsingDirectives(tokens);
                for (Token token : tokens) {
                    if (GenericTokenType.EOF.equals((Object)token.getType())) break;
                    TokenEntry cpdToken = new TokenEntry(this.getTokenImage(token), fileName, token.getLine());
                    cpdTokens.add(cpdToken);
                }
                cpdTokens.add(TokenEntry.getEOF());
            }

            private String getTokenImage(Token token) {
                if (GenericTokenType.LITERAL.equals((Object)token.getType())) {
                    return GenericTokenType.LITERAL.getValue();
                }
                return token.getValue();
            }

            private List<Token> removeUsingDirectives(List<Token> tokens) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < tokens.size() - 1; ++i) {
                    Token token = tokens.get(i);
                    if ("using".equals(token.getOriginalValue()) && !"(".equals(tokens.get(i + 1).getOriginalValue())) {
                        while (i < tokens.size() - 1 && !";".equals(tokens.get(i).getOriginalValue())) {
                            ++i;
                        }
                        continue;
                    }
                    builder.add((Object)token);
                }
                builder.add((Object)tokens.get(tokens.size() - 1));
                return builder.build();
            }
        };
    }

    private static enum CSharpPunctuator implements TokenType
    {
        SEMICOLON(";"),
        EQUAL("="),
        STAR("*"),
        LCURLYBRACE("{"),
        LPARENTHESIS("("),
        LBRACKET("["),
        RBRACKET("]"),
        RPARENTHESIS(")"),
        RCURLYBRACE("}"),
        COLON(":"),
        COMMA(","),
        DOT("."),
        EXCLAMATION("!"),
        SUPERIOR(">"),
        INFERIOR("<"),
        PLUS("+"),
        MINUS("-"),
        SLASH("/"),
        MODULO("%"),
        AND("&"),
        XOR("^"),
        OR("|"),
        QUESTION("?"),
        TILDE("~"),
        DOUBLE_COLON("::"),
        DOUBLE_QUESTION("??"),
        EQ_OP("=="),
        NE_OP("!="),
        LEFT_ASSIGN("<<="),
        ADD_ASSIGN("+="),
        SUB_ASSIGN("-="),
        MUL_ASSIGN("*="),
        DIV_ASSIGN("/="),
        MOD_ASSIGN("%="),
        AND_ASSIGN("&="),
        XOR_ASSIGN("^="),
        OR_ASSIGN("|="),
        LEFT_OP("<<"),
        INC_OP("++"),
        DEC_OP("--"),
        PTR_OP("->"),
        AND_OP("&&"),
        OR_OP("||"),
        LE_OP("<="),
        GE_OP(">="),
        LAMBDA("=>");

        private final String value;

        private CSharpPunctuator(String word) {
            this.value = word;
        }

        public String getName() {
            return this.name();
        }

        public String getValue() {
            return this.value;
        }

        public boolean hasToBeSkippedFromAst(AstNode node) {
            return false;
        }
    }
}

