/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.Settings;
import org.sonar.plugins.dotnet.tests.CoverageAggregator;
import org.sonar.plugins.dotnet.tests.CoverageConfiguration;
import org.sonar.plugins.dotnet.tests.CoverageReportImportSensor;

public class CSharpCodeCoverageProvider {
    private static final String CATEGORY = "C#";
    private static final String SUBCATEGORY = "Code Coverage";
    private static final String NCOVER3_PROPERTY_KEY = "sonar.cs.ncover3.reportsPaths";
    private static final String OPENCOVER_PROPERTY_KEY = "sonar.cs.opencover.reportsPaths";
    private static final String DOTCOVER_PROPERTY_KEY = "sonar.cs.dotcover.reportsPaths";
    private static final String VISUAL_STUDIO_COVERAGE_XML_PROPERTY_KEY = "sonar.cs.vscoveragexml.reportsPaths";
    private static final CoverageConfiguration COVERAGE_CONF = new CoverageConfiguration("cs", "sonar.cs.ncover3.reportsPaths", "sonar.cs.opencover.reportsPaths", "sonar.cs.dotcover.reportsPaths", "sonar.cs.vscoveragexml.reportsPaths");

    private CSharpCodeCoverageProvider() {
    }

    public static List extensions() {
        return ImmutableList.of(CSharpCoverageAggregator.class, CSharpCoverageReportImportSensor.class, (Object)PropertyDefinition.builder((String)NCOVER3_PROPERTY_KEY).name("NCover3 Reports Paths").description("Example: \"report.nccov\", \"report1.nccov,report2.nccov\" or \"C:/report.nccov\"").category(CATEGORY).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)OPENCOVER_PROPERTY_KEY).name("OpenCover Reports Paths").description("Example: \"report.xml\", \"report1.xml,report2.xml\" or \"C:/report.xml\"").category(CATEGORY).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)DOTCOVER_PROPERTY_KEY).name("dotCover (HTML) Reports Paths").description("Example: \"report.html\", \"report1.html,report2.html\" or \"C:/report.html\"").category(CATEGORY).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)VISUAL_STUDIO_COVERAGE_XML_PROPERTY_KEY).name("Visual Studio (XML) Reports Paths").description("Example: \"report.coveragexml\", \"report1.coveragexml,report2.coveragexml\" or \"C:/report.coveragexml\"").category(CATEGORY).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[]{"BRC"}).build());
    }

    public static class CSharpCoverageReportImportSensor
    extends CoverageReportImportSensor {
        public CSharpCoverageReportImportSensor(CSharpCoverageAggregator coverageAggregator, FileSystem fs) {
            super(COVERAGE_CONF, (CoverageAggregator)coverageAggregator, fs);
        }
    }

    public static class CSharpCoverageAggregator
    extends CoverageAggregator {
        public CSharpCoverageAggregator(Settings settings) {
            super(COVERAGE_CONF, settings);
        }
    }
}

