/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.plugins.fxcop.FxCopConfiguration;
import org.sonar.plugins.fxcop.FxCopRulesDefinition;
import org.sonar.plugins.fxcop.FxCopSensor;
import org.sonar.squidbridge.rules.SqaleXmlLoader;

public class CSharpFxCopProvider {
    private static final String CATEGORY = "C#";
    private static final String SUBCATEGORY = "Deprecated";
    private static final String DEPRECATION_TEXT = "This deprecated property is not used anymore and so must be ignored when launching the SonarQube analysis of .NET projects with help of the MSBuild Runner. If the old deprecated Visual Studio Bootstrapper plugin is still used along with SonarRunner to analyse .NET projects, moving to the MSBuild Runner should be scheduled because one day the backward support of the Visual Studio Boostrapper plugin will be dropped.";
    private static final String FXCOP_ASSEMBLIES_PROPERTY_KEY = "sonar.cs.fxcop.assembly";
    private static final String FXCOP_FXCOPCMD_PATH_PROPERTY_KEY = "sonar.cs.fxcop.fxCopCmdPath";
    private static final String FXCOP_TIMEOUT_PROPERTY_KEY = "sonar.cs.fxcop.timeoutMinutes";
    private static final String FXCOP_ASPNET_PROPERTY_KEY = "sonar.cs.fxcop.aspnet";
    private static final String FXCOP_DIRECTORIES_PROPERTY_KEY = "sonar.cs.fxcop.directories";
    private static final String FXCOP_REFERENCES_PROPERTY_KEY = "sonar.cs.fxcop.references";
    private static final String FXCOP_REPORT_PATH_PROPERTY_KEY = "sonar.cs.fxcop.reportPath";
    private static final FxCopConfiguration FXCOP_CONF = new FxCopConfiguration("cs", "fxcop", "sonar.cs.fxcop.assembly", "sonar.cs.fxcop.fxCopCmdPath", "sonar.cs.fxcop.timeoutMinutes", "sonar.cs.fxcop.aspnet", "sonar.cs.fxcop.directories", "sonar.cs.fxcop.references", "sonar.cs.fxcop.reportPath");

    private CSharpFxCopProvider() {
    }

    public static List extensions() {
        return ImmutableList.of(CSharpFxCopRulesDefinition.class, CSharpFxCopSensor.class, (Object)PropertyDefinition.builder((String)FXCOP_TIMEOUT_PROPERTY_KEY).name(CSharpFxCopProvider.deprecatedName("FxCop execution timeout")).description(CSharpFxCopProvider.deprecatedDescription("Time in minutes after which FxCop's execution should be interrupted if not finished")).defaultValue("10").category(CATEGORY).subCategory(SUBCATEGORY).onQualifiers("TRK", new String[0]).type(PropertyType.INTEGER).build(), (Object)PropertyDefinition.builder((String)FXCOP_ASSEMBLIES_PROPERTY_KEY).name(CSharpFxCopProvider.deprecatedName("Assembly to analyze")).description(CSharpFxCopProvider.deprecatedDescription("Example: bin/Debug/MyProject.dll")).category(CATEGORY).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)FXCOP_FXCOPCMD_PATH_PROPERTY_KEY).name(CSharpFxCopProvider.deprecatedName("Path to FxCopCmd.exe")).description(CSharpFxCopProvider.deprecatedDescription("Example: C:/Program Files (x86)/Microsoft Visual Studio 12.0/Team Tools/Static Analysis Tools/FxCop/FxCopCmd.exe")).defaultValue("C:/Program Files (x86)/Microsoft Visual Studio 12.0/Team Tools/Static Analysis Tools/FxCop/FxCopCmd.exe").category(CATEGORY).subCategory(SUBCATEGORY).onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)FXCOP_ASPNET_PROPERTY_KEY).name(CSharpFxCopProvider.deprecatedName("ASP.NET")).description(CSharpFxCopProvider.deprecatedDescription("Whether or not to set the /aspnet flag when launching FxCopCmd.exe")).defaultValue("false").category(CATEGORY).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)FXCOP_DIRECTORIES_PROPERTY_KEY).name(CSharpFxCopProvider.deprecatedName("Additional assemblies directories")).description(CSharpFxCopProvider.deprecatedDescription("Comma-separated list of directories where FxCop should look for referenced assemblies. Example: c:/MyLibrary")).category(CATEGORY).subCategory(SUBCATEGORY).onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)FXCOP_REFERENCES_PROPERTY_KEY).name(CSharpFxCopProvider.deprecatedName("Additional assemblies references")).description(CSharpFxCopProvider.deprecatedDescription("Comma-separated list of referenced assemblies to pass to FxCop. Example: c:/MyLibrary.dll")).category(CATEGORY).subCategory(SUBCATEGORY).onQualifiers("TRK", new String[]{"BRC"}).build());
    }

    private static String deprecatedDescription(String description) {
        return description + "<br /><br />" + DEPRECATION_TEXT;
    }

    private static String deprecatedName(String name) {
        return "Deprecated - " + name;
    }

    public static class CSharpFxCopSensor
    extends FxCopSensor {
        public CSharpFxCopSensor(Settings settings, RulesProfile profile, FileSystem fs, ResourcePerspectives perspectives) {
            super(FXCOP_CONF, settings, profile, fs, perspectives);
        }
    }

    public static class CSharpFxCopRulesDefinition
    extends FxCopRulesDefinition {
        public CSharpFxCopRulesDefinition() {
            super(FXCOP_CONF, new FxCopRulesDefinition.FxCopRulesDefinitionSqaleLoader(){

                public void loadSqale(RulesDefinition.NewRepository repository) {
                    SqaleXmlLoader.load((RulesDefinition.NewRepository)repository, (String)"/com/sonar/sqale/fxcop.xml");
                }
            });
        }
    }
}

