/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.rules.Rule;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandExecutor;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.plugins.csharp.RoslynProfileExporter;
import org.sonar.plugins.csharp.RuleRunnerExtractor;

public class CSharpSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(CSharpSensor.class);
    private static final String ROSLYN_REPORT_PATH_PROPERTY_KEY = "sonar.cs.roslyn.reportFilePath";
    private final Settings settings;
    private final RuleRunnerExtractor extractor;
    private final FileSystem fs;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final RulesProfile ruleProfile;
    private final ResourcePerspectives perspectives;

    public CSharpSensor(Settings settings, RuleRunnerExtractor extractor, FileSystem fs, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, RulesProfile ruleProfile, ResourcePerspectives perspectives) {
        this.settings = settings;
        this.extractor = extractor;
        this.fs = fs;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.ruleProfile = ruleProfile;
        this.perspectives = perspectives;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.filesToAnalyze().iterator().hasNext();
    }

    public void analyse(Project project, SensorContext context) {
        String roslynReportPath = this.settings.getString(ROSLYN_REPORT_PATH_PROPERTY_KEY);
        boolean hasRoslynReportPath = roslynReportPath != null;
        this.analyze(!hasRoslynReportPath);
        this.importResults(project, context);
        if (hasRoslynReportPath) {
            this.importRoslynReport(roslynReportPath, (Issuable)this.perspectives.as(Issuable.class, (Resource)project));
        }
    }

    private void analyze(boolean includeRules) {
        if (includeRules) {
            LOG.warn("**********************************************************************************");
            LOG.warn("*                Use MSBuild 14 to get the best analysis results                 *");
            LOG.warn("* The use of MSBuild 12 or the sonar-runner to analyze C# projects is DEPRECATED *");
            LOG.warn("**********************************************************************************");
            ImmutableMultimap<String, ActiveRule> activeRoslynRulesByPartialRepoKey = RoslynProfileExporter.activeRoslynRulesByPartialRepoKey(this.ruleProfile.getActiveRules());
            if (activeRoslynRulesByPartialRepoKey.keySet().size() > 1) {
                throw new IllegalArgumentException("Custom and 3rd party Roslyn analyzers are only by MSBuild 14. Either use MSBuild 14, or disable the custom/3rd party Roslyn analyzers in your quality profile.");
            }
        }
        String analysisSettings = CSharpSensor.analysisSettings(true, this.settings.getBoolean("sonar.cs.ignoreHeaderComments"), includeRules, this.ruleProfile, this.filesToAnalyze());
        File analysisInput = this.toolInput();
        File analysisOutput = this.toolOutput();
        try {
            Files.write((CharSequence)analysisSettings, (File)analysisInput, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        File executableFile = this.extractor.executableFile();
        Command command = Command.create((String)executableFile.getAbsolutePath()).addArgument(analysisInput.getAbsolutePath()).addArgument(analysisOutput.getAbsolutePath()).addArgument("cs");
        int exitCode = CommandExecutor.create().execute(command, (StreamConsumer)new LogInfoStreamConsumer(), (StreamConsumer)new LogErrorStreamConsumer(), Integer.MAX_VALUE);
        if (exitCode != 0) {
            throw new IllegalStateException("The .NET analyzer failed with exit code: " + exitCode + " - Verify that the .NET Framework version 4.5.2 at least is installed.");
        }
    }

    public static String analysisSettings(boolean includeSettings, boolean ignoreHeaderComments, boolean includeRules, RulesProfile ruleProfile, Iterable<File> files) {
        StringBuilder sb = new StringBuilder();
        CSharpSensor.appendLine(sb, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        CSharpSensor.appendLine(sb, "<AnalysisInput>");
        if (includeSettings) {
            CSharpSensor.appendLine(sb, "  <Settings>");
            CSharpSensor.appendLine(sb, "    <Setting>");
            CSharpSensor.appendLine(sb, "      <Key>sonar.cs.ignoreHeaderComments</Key>");
            CSharpSensor.appendLine(sb, "      <Value>" + (ignoreHeaderComments ? "true" : "false") + "</Value>");
            CSharpSensor.appendLine(sb, "    </Setting>");
            CSharpSensor.appendLine(sb, "  </Settings>");
        }
        CSharpSensor.appendLine(sb, "  <Rules>");
        if (includeRules) {
            for (ActiveRule activeRule : ruleProfile.getActiveRulesByRepository("csharpsquid")) {
                CSharpSensor.appendLine(sb, "    <Rule>");
                Rule template = activeRule.getRule().getTemplate();
                String ruleKey = template == null ? activeRule.getRuleKey() : template.getKey();
                CSharpSensor.appendLine(sb, "      <Key>" + CSharpSensor.escapeXml(ruleKey) + "</Key>");
                Map<String, String> parameters = CSharpSensor.effectiveParameters(activeRule);
                if (!parameters.isEmpty()) {
                    CSharpSensor.appendLine(sb, "      <Parameters>");
                    for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                        CSharpSensor.appendLine(sb, "        <Parameter>");
                        CSharpSensor.appendLine(sb, "          <Key>" + CSharpSensor.escapeXml(parameter.getKey()) + "</Key>");
                        CSharpSensor.appendLine(sb, "          <Value>" + CSharpSensor.escapeXml(parameter.getValue()) + "</Value>");
                        CSharpSensor.appendLine(sb, "        </Parameter>");
                    }
                    CSharpSensor.appendLine(sb, "      </Parameters>");
                }
                CSharpSensor.appendLine(sb, "    </Rule>");
            }
        }
        CSharpSensor.appendLine(sb, "  </Rules>");
        CSharpSensor.appendLine(sb, "  <Files>");
        for (File file : files) {
            CSharpSensor.appendLine(sb, "    <File>" + CSharpSensor.escapeXml(file.getAbsolutePath()) + "</File>");
        }
        CSharpSensor.appendLine(sb, "  </Files>");
        CSharpSensor.appendLine(sb, "</AnalysisInput>");
        return sb.toString();
    }

    private static String escapeXml(String str) {
        return str.replace("&", "&amp;").replace("\"", "&quot;").replace("'", "&apos;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static Map<String, String> effectiveParameters(ActiveRule activeRule) {
        HashMap builder = Maps.newHashMap();
        if (activeRule.getRule().getTemplate() != null) {
            builder.put("RuleKey", activeRule.getRuleKey());
        }
        for (ActiveRuleParam param : activeRule.getActiveRuleParams()) {
            builder.put(param.getKey(), param.getValue());
        }
        for (ActiveRuleParam param : activeRule.getRule().getParams()) {
            if (builder.containsKey(param.getKey())) continue;
            builder.put(param.getKey(), param.getDefaultValue());
        }
        return ImmutableMap.copyOf((Map)builder);
    }

    private void importResults(Project project, SensorContext context) {
        File analysisOutput = this.toolOutput();
        new AnalysisResultImporter(context, this.fs, this.fileLinesContextFactory, this.noSonarFilter, this.perspectives).parse(analysisOutput);
    }

    private void importRoslynReport(String reportPath, Issuable projectIssuable) {
        String contents;
        try {
            contents = Files.toString((File)new File(reportPath), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableMultimap<String, ActiveRule> activeRoslynRulesByPartialRepoKey = RoslynProfileExporter.activeRoslynRulesByPartialRepoKey(this.ruleProfile.getActiveRules());
        HashMap repositoryKeyByRoslynRuleKey = Maps.newHashMap();
        for (ActiveRule activeRoslynRule : activeRoslynRulesByPartialRepoKey.values()) {
            String previousRepositoryKey = repositoryKeyByRoslynRuleKey.put(activeRoslynRule.getRuleKey(), activeRoslynRule.getRepositoryKey());
            if (previousRepositoryKey == null) continue;
            throw new IllegalArgumentException("Rule keys must be unique, but \"" + activeRoslynRule.getRuleKey() + "\" is defined in both the \"" + previousRepositoryKey + "\" and \"" + activeRoslynRule.getRepositoryKey() + "\" rule repositories.");
        }
        JsonParser parser = new JsonParser();
        JsonElement issues = parser.parse(contents).getAsJsonObject().get("issues");
        if (issues != null) {
            for (JsonElement issueElement : issues.getAsJsonArray()) {
                JsonObject issue = issueElement.getAsJsonObject();
                String ruleId = issue.get("ruleId").getAsString();
                if (!repositoryKeyByRoslynRuleKey.containsKey(ruleId)) continue;
                String message = issue.get(issue.has("shortMessage") ? "shortMessage" : "fullMessage").getAsString();
                boolean hasLocation = false;
                for (JsonElement locationElement : issue.get("locations").getAsJsonArray()) {
                    JsonObject location = locationElement.getAsJsonObject();
                    if (!location.has("analysisTarget")) continue;
                    for (JsonElement analysisTargetElement : location.get("analysisTarget").getAsJsonArray()) {
                        hasLocation = true;
                        JsonObject analysisTarget = analysisTargetElement.getAsJsonObject();
                        String uri = analysisTarget.get("uri").getAsString();
                        JsonObject region = analysisTarget.get("region").getAsJsonObject();
                        int startLine = region.get("startLine").getAsInt();
                        this.handleRoslynIssue((String)repositoryKeyByRoslynRuleKey.get(ruleId), ruleId, uri, startLine, message);
                    }
                }
                if (hasLocation || projectIssuable == null) continue;
                CSharpSensor.handleRoslynProjectIssue(projectIssuable, (String)repositoryKeyByRoslynRuleKey.get(ruleId), ruleId, message);
            }
        }
    }

    private void handleRoslynIssue(String repositoryKey, String ruleId, String uri, int startLine, String fullMessage) {
        Issuable issuable;
        InputFile inputFile = this.fs.inputFile(this.fs.predicates().hasAbsolutePath(uri));
        if (inputFile != null && (issuable = (Issuable)this.perspectives.as(Issuable.class, (InputPath)inputFile)) != null) {
            Issuable.IssueBuilder builder = issuable.newIssueBuilder();
            builder.ruleKey(RuleKey.of((String)repositoryKey, (String)ruleId));
            builder.line(Integer.valueOf(startLine + 1));
            builder.message(fullMessage);
            issuable.addIssue(builder.build());
        }
    }

    private static void handleRoslynProjectIssue(Issuable projectIssuable, String repositoryKey, String ruleId, String fullMessage) {
        Issuable.IssueBuilder builder = projectIssuable.newIssueBuilder();
        builder.ruleKey(RuleKey.of((String)repositoryKey, (String)ruleId));
        builder.message(fullMessage);
        projectIssuable.addIssue(builder.build());
    }

    private static void appendLine(StringBuilder sb, String line) {
        sb.append(line);
        sb.append("\r\n");
    }

    private Iterable<File> filesToAnalyze() {
        return this.fs.files(this.fs.predicates().and(this.fs.predicates().hasType(InputFile.Type.MAIN), this.fs.predicates().hasLanguage("cs")));
    }

    private File toolInput() {
        return new File(this.fs.workDir(), "SonarLint.xml");
    }

    private File toolOutput() {
        return CSharpSensor.toolOutput(this.fs);
    }

    public static File toolOutput(FileSystem fileSystem) {
        return new File(fileSystem.workDir(), "analysis-output.xml");
    }

    private static class LogErrorStreamConsumer
    implements StreamConsumer {
        private LogErrorStreamConsumer() {
        }

        public void consumeLine(String line) {
            LOG.error(line);
        }
    }

    private static class LogInfoStreamConsumer
    implements StreamConsumer {
        private LogInfoStreamConsumer() {
        }

        public void consumeLine(String line) {
            LOG.info(line);
        }
    }

    private static class AnalysisResultImporter {
        private final SensorContext context;
        private final FileSystem fs;
        private XMLStreamReader stream;
        private final FileLinesContextFactory fileLinesContextFactory;
        private final NoSonarFilter noSonarFilter;
        private final ResourcePerspectives perspectives;

        public AnalysisResultImporter(SensorContext context, FileSystem fs, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, ResourcePerspectives perspectives) {
            this.context = context;
            this.fs = fs;
            this.fileLinesContextFactory = fileLinesContextFactory;
            this.noSonarFilter = noSonarFilter;
            this.perspectives = perspectives;
        }

        public void parse(File file) {
            XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);){
                this.stream = xmlFactory.createXMLStreamReader(reader);
                while (this.stream.hasNext()) {
                    String tagName;
                    if (this.stream.next() != 1 || !"File".equals(tagName = this.stream.getLocalName())) continue;
                    this.handleFileTag();
                }
            }
            catch (IOException | XMLStreamException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.closeXmlStream();
            }
        }

        private void closeXmlStream() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (XMLStreamException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }

        private void handleFileTag() throws XMLStreamException {
            int next;
            InputFile inputFile = null;
            while (this.stream.hasNext() && ((next = this.stream.next()) != 2 || !"File".equals(this.stream.getLocalName()))) {
                if (next != 1) continue;
                String tagName = this.stream.getLocalName();
                if ("Path".equals(tagName)) {
                    String path = this.stream.getElementText();
                    inputFile = this.fs.inputFile(this.fs.predicates().hasAbsolutePath(path));
                    continue;
                }
                if ("Metrics".equals(tagName)) {
                    Preconditions.checkState((inputFile != null ? 1 : 0) != 0);
                    this.handleMetricsTag(inputFile);
                    continue;
                }
                if (!"Issues".equals(tagName)) continue;
                Preconditions.checkState((inputFile != null ? 1 : 0) != 0);
                this.handleIssuesTag(inputFile);
            }
        }

        private void handleMetricsTag(InputFile inputFile) throws XMLStreamException {
            int next;
            while (this.stream.hasNext() && ((next = this.stream.next()) != 2 || !"Metrics".equals(this.stream.getLocalName()))) {
                if (next != 1) continue;
                String tagName = this.stream.getLocalName();
                if ("Lines".equals(tagName)) {
                    this.handleLinesMetricTag(inputFile);
                    continue;
                }
                if ("Classes".equals(tagName)) {
                    this.handleClassesMetricTag(inputFile);
                    continue;
                }
                if ("Accessors".equals(tagName)) {
                    this.handleAccessorsMetricTag(inputFile);
                    continue;
                }
                if ("Statements".equals(tagName)) {
                    this.handleStatementsMetricTag(inputFile);
                    continue;
                }
                if ("Functions".equals(tagName)) {
                    this.handleFunctionsMetricTag(inputFile);
                    continue;
                }
                if ("PublicApi".equals(tagName)) {
                    this.handlePublicApiMetricTag(inputFile);
                    continue;
                }
                if ("PublicUndocumentedApi".equals(tagName)) {
                    this.handlePublicUndocumentedApiMetricTag(inputFile);
                    continue;
                }
                if ("Complexity".equals(tagName)) {
                    this.handleComplexityMetricTag(inputFile);
                    continue;
                }
                if ("FileComplexityDistribution".equals(tagName)) {
                    this.handleFileComplexityDistributionMetricTag(inputFile);
                    continue;
                }
                if ("FunctionComplexityDistribution".equals(tagName)) {
                    this.handleFunctionComplexityDistributionMetricTag(inputFile);
                    continue;
                }
                if ("Comments".equals(tagName)) {
                    this.handleCommentsMetricTag(inputFile);
                    continue;
                }
                if (!"LinesOfCode".equals(tagName)) continue;
                this.handleLinesOfCodeMetricTag(inputFile);
            }
        }

        private void handleLinesMetricTag(InputFile inputFile) throws XMLStreamException {
            double value = Double.parseDouble(this.stream.getElementText());
            this.context.saveMeasure(inputFile, CoreMetrics.LINES, Double.valueOf(value));
        }

        private void handleClassesMetricTag(InputFile inputFile) throws XMLStreamException {
            double value = Double.parseDouble(this.stream.getElementText());
            this.context.saveMeasure(inputFile, CoreMetrics.CLASSES, Double.valueOf(value));
        }

        private void handleAccessorsMetricTag(InputFile inputFile) throws XMLStreamException {
            double value = Double.parseDouble(this.stream.getElementText());
            this.context.saveMeasure(inputFile, CoreMetrics.ACCESSORS, Double.valueOf(value));
        }

        private void handleStatementsMetricTag(InputFile inputFile) throws XMLStreamException {
            double value = Double.parseDouble(this.stream.getElementText());
            this.context.saveMeasure(inputFile, CoreMetrics.STATEMENTS, Double.valueOf(value));
        }

        private void handleFunctionsMetricTag(InputFile inputFile) throws XMLStreamException {
            double value = Double.parseDouble(this.stream.getElementText());
            this.context.saveMeasure(inputFile, CoreMetrics.FUNCTIONS, Double.valueOf(value));
        }

        private void handlePublicApiMetricTag(InputFile inputFile) throws XMLStreamException {
            double value = Double.parseDouble(this.stream.getElementText());
            this.context.saveMeasure(inputFile, CoreMetrics.PUBLIC_API, Double.valueOf(value));
        }

        private void handlePublicUndocumentedApiMetricTag(InputFile inputFile) throws XMLStreamException {
            double value = Double.parseDouble(this.stream.getElementText());
            this.context.saveMeasure(inputFile, CoreMetrics.PUBLIC_UNDOCUMENTED_API, Double.valueOf(value));
        }

        private void handleComplexityMetricTag(InputFile inputFile) throws XMLStreamException {
            double value = Double.parseDouble(this.stream.getElementText());
            this.context.saveMeasure(inputFile, CoreMetrics.COMPLEXITY, Double.valueOf(value));
        }

        private void handleFileComplexityDistributionMetricTag(InputFile inputFile) throws XMLStreamException {
            String value = this.stream.getElementText();
            this.context.saveMeasure(inputFile, new Measure(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, value).setPersistenceMode(PersistenceMode.MEMORY));
        }

        private void handleFunctionComplexityDistributionMetricTag(InputFile inputFile) throws XMLStreamException {
            String value = this.stream.getElementText();
            this.context.saveMeasure(inputFile, new Measure(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, value).setPersistenceMode(PersistenceMode.MEMORY));
        }

        private void handleCommentsMetricTag(InputFile inputFile) throws XMLStreamException {
            int next;
            while (this.stream.hasNext() && ((next = this.stream.next()) != 2 || !"Comments".equals(this.stream.getLocalName()))) {
                if (next != 1) continue;
                String tagName = this.stream.getLocalName();
                if ("NoSonar".equals(tagName)) {
                    this.handleNoSonarCommentsMetricTag(inputFile);
                    continue;
                }
                if (!"NonBlank".equals(tagName)) continue;
                this.handleNonBlankCommentsMetricTag(inputFile);
            }
        }

        private void handleNoSonarCommentsMetricTag(InputFile inputFile) throws XMLStreamException {
            int next;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            while (this.stream.hasNext() && ((next = this.stream.next()) != 2 || !"NoSonar".equals(this.stream.getLocalName()))) {
                if (next != 1) continue;
                String tagName = this.stream.getLocalName();
                if ("Line".equals(tagName)) {
                    int line = Integer.parseInt(this.stream.getElementText());
                    builder.add((Object)line);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            this.noSonarFilter.addComponent(((DefaultInputFile)inputFile).key(), (Set)builder.build());
        }

        private void handleNonBlankCommentsMetricTag(InputFile inputFile) throws XMLStreamException {
            int next;
            double value = 0.0;
            FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
            while (this.stream.hasNext() && ((next = this.stream.next()) != 2 || !"NonBlank".equals(this.stream.getLocalName()))) {
                if (next != 1) continue;
                String tagName = this.stream.getLocalName();
                if ("Line".equals(tagName)) {
                    value += 1.0;
                    int line = Integer.parseInt(this.stream.getElementText());
                    fileLinesContext.setIntValue("comment_lines_data", line, 1);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            fileLinesContext.save();
            this.context.saveMeasure(inputFile, CoreMetrics.COMMENT_LINES, Double.valueOf(value));
        }

        private void handleLinesOfCodeMetricTag(InputFile inputFile) throws XMLStreamException {
            int next;
            double value = 0.0;
            FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
            while (this.stream.hasNext() && ((next = this.stream.next()) != 2 || !"LinesOfCode".equals(this.stream.getLocalName()))) {
                if (next != 1) continue;
                String tagName = this.stream.getLocalName();
                if ("Line".equals(tagName)) {
                    value += 1.0;
                    int line = Integer.parseInt(this.stream.getElementText());
                    fileLinesContext.setIntValue("ncloc_data", line, 1);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            fileLinesContext.save();
            this.context.saveMeasure(inputFile, CoreMetrics.NCLOC, Double.valueOf(value));
        }

        private void handleIssuesTag(InputFile inputFile) throws XMLStreamException {
            int next;
            Issuable issuable = (Issuable)this.perspectives.as(Issuable.class, (InputPath)inputFile);
            while (this.stream.hasNext() && ((next = this.stream.next()) != 2 || !"Issues".equals(this.stream.getLocalName()))) {
                String tagName;
                if (next != 1 || !"Issue".equals(tagName = this.stream.getLocalName()) || issuable == null) continue;
                this.handleIssueTag(issuable);
            }
        }

        private void handleIssueTag(Issuable issuable) throws XMLStreamException {
            Issuable.IssueBuilder builder = issuable.newIssueBuilder();
            String id = null;
            String message = null;
            while (this.stream.hasNext()) {
                int next = this.stream.next();
                if (next == 2 && "Issue".equals(this.stream.getLocalName())) {
                    Preconditions.checkState((!"AnalyzerDriver".equals(id) ? 1 : 0) != 0, (Object)("The analyzer failed, double check rule parameters or disable failing rules: " + message));
                    builder.ruleKey(RuleKey.of((String)"csharpsquid", (String)id));
                    builder.message(message);
                    issuable.addIssue(builder.build());
                    break;
                }
                if (next != 1) continue;
                String tagName = this.stream.getLocalName();
                if ("Id".equals(tagName)) {
                    id = this.stream.getElementText();
                    continue;
                }
                if ("Line".equals(tagName)) {
                    builder.line(Integer.valueOf(Integer.parseInt(this.stream.getElementText())));
                    continue;
                }
                if (!"Message".equals(tagName)) continue;
                message = this.stream.getElementText();
            }
        }
    }
}

