/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import org.sonar.api.BatchExtension;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;
import org.sonar.squidbridge.rules.SqaleXmlLoader;

public class CSharpSonarRulesDefinition
implements RulesDefinition,
BatchExtension {
    private Set<String> allRuleKeys = null;

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository("csharpsquid", "cs").setName("SonarQube");
        RulesDefinitionXmlLoader loader = new RulesDefinitionXmlLoader();
        loader.load(repository, (Reader)new InputStreamReader(this.getClass().getResourceAsStream("/org/sonar/plugins/csharp/rules.xml"), Charsets.UTF_8));
        SqaleXmlLoader.load((RulesDefinition.NewRepository)repository, (String)"/org/sonar/plugins/csharp/sqale.xml");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (RulesDefinition.NewRule rule : repository.rules()) {
            builder.add((Object)rule.key());
        }
        this.allRuleKeys = builder.build();
        repository.done();
    }

    public Set<String> allRuleKeys() {
        Preconditions.checkNotNull(this.allRuleKeys);
        return this.allRuleKeys;
    }
}

