/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.api.web.CodeColorizerFormat;
import org.sonar.colorizer.CDocTokenizer;
import org.sonar.colorizer.CppDocTokenizer;
import org.sonar.colorizer.KeywordsTokenizer;
import org.sonar.colorizer.LiteralTokenizer;
import org.sonar.colorizer.RegexpTokenizer;
import org.sonar.colorizer.Tokenizer;

public class CSharpSourceCodeColorizer
extends CodeColorizerFormat {
    private static final Set<String> KEYWORDS = ImmutableSet.of((Object)"abstract", (Object)"as", (Object)"base", (Object)"bool", (Object)"break", (Object)"byte", (Object[])new String[]{"case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while"});
    private static final String SPAN = "</span>";

    public CSharpSourceCodeColorizer() {
        super("cs");
    }

    public List<Tokenizer> getTokenizers() {
        ArrayList<Tokenizer> tokenizers = new ArrayList<Tokenizer>();
        tokenizers.add((Tokenizer)new CDocTokenizer("<span class=\"cd\">", SPAN));
        tokenizers.add((Tokenizer)new CppDocTokenizer("<span class=\"cppd\">", SPAN));
        tokenizers.add((Tokenizer)new KeywordsTokenizer("<span class=\"k\">", SPAN, KEYWORDS));
        tokenizers.add((Tokenizer)new LiteralTokenizer("<span class=\"s\">", SPAN));
        tokenizers.add((Tokenizer)new RegexpTokenizer("<span class=\"j\">", SPAN, "#[^\\n\\r]*+"));
        tokenizers.add((Tokenizer)new RegexpTokenizer("<span class=\"c\">", SPAN, "[+-]?[0-9]++(\\.[0-9]*+)?"));
        return tokenizers;
    }
}

