/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.plugins.csharp.CSharpSensor;

public class RoslynProfileExporter
extends ProfileExporter {
    private static final String SONARANALYZER_PARTIAL_REPO_KEY = "sonaranalyzer-cs";
    private static final String SONARANALYZER_NUGET_VERSION = "1.10.0";
    private static final String ROSLYN_REPOSITORY_PREFIX = "roslyn.";
    private final Settings settings;
    private final RulesDefinition[] rulesDefinitions;

    public RoslynProfileExporter(Settings settings, RulesDefinition[] rulesDefinitions) {
        super("roslyn-cs", "Technical exporter for the MSBuild SonarQube Scanner");
        this.settings = settings;
        this.rulesDefinitions = rulesDefinitions;
        this.setSupportedLanguages(new String[]{"cs"});
    }

    public static List<PropertyDefinition> sonarLintRepositoryProperties() {
        return Arrays.asList(PropertyDefinition.builder((String)RoslynProfileExporter.pluginKeyPropertyKey(SONARANALYZER_PARTIAL_REPO_KEY)).defaultValue("csharp").hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.pluginVersionPropertyKey(SONARANALYZER_PARTIAL_REPO_KEY)).defaultValue(SONARANALYZER_NUGET_VERSION).hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.staticResourceNamePropertyKey(SONARANALYZER_PARTIAL_REPO_KEY)).defaultValue("SonarAnalyzer.zip").hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.analyzerIdPropertyKey(SONARANALYZER_PARTIAL_REPO_KEY)).defaultValue("SonarAnalyzer.CSharp").hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.ruleNamespacePropertyKey(SONARANALYZER_PARTIAL_REPO_KEY)).defaultValue("SonarAnalyzer.CSharp").hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.nugetPackageIdPropertyKey(SONARANALYZER_PARTIAL_REPO_KEY)).defaultValue("SonarAnalyzer.CSharp").hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.nugetPackageVersionPropertyKey(SONARANALYZER_PARTIAL_REPO_KEY)).defaultValue(SONARANALYZER_NUGET_VERSION).hidden().build());
    }

    public void exportProfile(RulesProfile rulesProfile, Writer writer) {
        ImmutableMultimap<String, ActiveRule> activeRoslynRulesByPartialRepoKey = RoslynProfileExporter.activeRoslynRulesByPartialRepoKey(rulesProfile.getActiveRules());
        RoslynProfileExporter.appendLine(writer, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        RoslynProfileExporter.appendLine(writer, "<RoslynExportProfile Version=\"1.0\">");
        RoslynProfileExporter.appendLine(writer, "  <Configuration>");
        RoslynProfileExporter.appendLine(writer, "    <RuleSet Name=\"Rules for SonarQube\" Description=\"This rule set was automatically generated from SonarQube.\" ToolsVersion=\"14.0\">");
        for (String partialRepoKey : activeRoslynRulesByPartialRepoKey.keySet()) {
            String analyzerId = this.mandatoryPropertyValue(RoslynProfileExporter.analyzerIdPropertyKey(partialRepoKey));
            String ruleNamespace = this.mandatoryPropertyValue(RoslynProfileExporter.ruleNamespacePropertyKey(partialRepoKey));
            RoslynProfileExporter.appendLine(writer, "      <Rules AnalyzerId=\"" + RoslynProfileExporter.escapeXml(analyzerId) + "\" RuleNamespace=\"" + RoslynProfileExporter.escapeXml(ruleNamespace) + "\">");
            HashSet activeRules = Sets.newHashSet();
            String repositoryKey = null;
            for (ActiveRule activeRule : activeRoslynRulesByPartialRepoKey.get((Object)partialRepoKey)) {
                if (repositoryKey == null) {
                    repositoryKey = activeRule.getRepositoryKey();
                }
                String ruleKey = activeRule.getRuleKey();
                activeRules.add(ruleKey);
                RoslynProfileExporter.appendLine(writer, "        <Rule Id=\"" + RoslynProfileExporter.escapeXml(ruleKey) + "\" Action=\"Warning\" />");
            }
            List<String> allRuleKeys = this.allRuleKeysByRepositoryKey(repositoryKey);
            for (String ruleKey : allRuleKeys) {
                if (activeRules.contains(ruleKey)) continue;
                RoslynProfileExporter.appendLine(writer, "        <Rule Id=\"" + RoslynProfileExporter.escapeXml(ruleKey) + "\" Action=\"None\" />");
            }
            RoslynProfileExporter.appendLine(writer, "      </Rules>");
        }
        RoslynProfileExporter.appendLine(writer, "    </RuleSet>");
        RoslynProfileExporter.appendLine(writer, "    <AdditionalFiles>");
        String sonarlintParameters = CSharpSensor.analysisSettings(false, false, true, rulesProfile, Collections.emptyList());
        String base64 = new String(Base64.encodeBase64((byte[])sonarlintParameters.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        RoslynProfileExporter.appendLine(writer, "      <AdditionalFile FileName=\"SonarLint.xml\">" + base64 + "</AdditionalFile>");
        RoslynProfileExporter.appendLine(writer, "    </AdditionalFiles>");
        RoslynProfileExporter.appendLine(writer, "  </Configuration>");
        RoslynProfileExporter.appendLine(writer, "  <Deployment>");
        RoslynProfileExporter.appendLine(writer, "    <Plugins>");
        for (String partialRepoKey : activeRoslynRulesByPartialRepoKey.keySet()) {
            String pluginKey = this.mandatoryPropertyValue(RoslynProfileExporter.pluginKeyPropertyKey(partialRepoKey));
            String pluginVersion = this.mandatoryPropertyValue(RoslynProfileExporter.pluginVersionPropertyKey(partialRepoKey));
            String staticResourceName = this.mandatoryPropertyValue(RoslynProfileExporter.staticResourceNamePropertyKey(partialRepoKey));
            RoslynProfileExporter.appendLine(writer, "      <Plugin Key=\"" + RoslynProfileExporter.escapeXml(pluginKey) + "\" Version=\"" + RoslynProfileExporter.escapeXml(pluginVersion) + "\" StaticResourceName=\"" + RoslynProfileExporter.escapeXml(staticResourceName) + "\" />");
        }
        RoslynProfileExporter.appendLine(writer, "    </Plugins>");
        RoslynProfileExporter.appendLine(writer, "    <NuGetPackages>");
        for (String partialRepoKey : activeRoslynRulesByPartialRepoKey.keySet()) {
            String packageId = this.mandatoryPropertyValue(RoslynProfileExporter.nugetPackageIdPropertyKey(partialRepoKey));
            String packageVersion = this.mandatoryPropertyValue(RoslynProfileExporter.nugetPackageVersionPropertyKey(partialRepoKey));
            RoslynProfileExporter.appendLine(writer, "      <NuGetPackage Id=\"" + RoslynProfileExporter.escapeXml(packageId) + "\" Version=\"" + RoslynProfileExporter.escapeXml(packageVersion) + "\" />");
        }
        RoslynProfileExporter.appendLine(writer, "    </NuGetPackages>");
        RoslynProfileExporter.appendLine(writer, "  </Deployment>");
        RoslynProfileExporter.appendLine(writer, "</RoslynExportProfile>");
    }

    public static ImmutableMultimap<String, ActiveRule> activeRoslynRulesByPartialRepoKey(List<ActiveRule> activeRules) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (ActiveRule activeRule : activeRules) {
            if (activeRule.getRepositoryKey().startsWith(ROSLYN_REPOSITORY_PREFIX)) {
                String pluginKey = activeRule.getRepositoryKey().substring(ROSLYN_REPOSITORY_PREFIX.length());
                builder.put((Object)pluginKey, (Object)activeRule);
                continue;
            }
            if (!"csharpsquid".equals(activeRule.getRepositoryKey())) continue;
            builder.put((Object)SONARANALYZER_PARTIAL_REPO_KEY, (Object)activeRule);
        }
        return builder.build();
    }

    private List<String> allRuleKeysByRepositoryKey(String repositoryKey) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RulesDefinition rulesDefinition : this.rulesDefinitions) {
            RulesDefinition.Context context = new RulesDefinition.Context();
            rulesDefinition.define(context);
            RulesDefinition.Repository repo = context.repository(repositoryKey);
            if (repo == null) continue;
            for (RulesDefinition.Rule rule : repo.rules()) {
                builder.add((Object)rule.key());
            }
        }
        return builder.build();
    }

    private String mandatoryPropertyValue(String propertyKey) {
        return (String)Preconditions.checkNotNull((Object)this.settings.getDefaultValue(propertyKey), (Object)("The mandatory property \"" + propertyKey + "\" must be set by the Roslyn plugin."));
    }

    private static String pluginKeyPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".pluginKey";
    }

    private static String pluginVersionPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".pluginVersion";
    }

    private static String staticResourceNamePropertyKey(String partialRepoKey) {
        return partialRepoKey + ".staticResourceName";
    }

    private static String analyzerIdPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".analyzerId";
    }

    private static String ruleNamespacePropertyKey(String partialRepoKey) {
        return partialRepoKey + ".ruleNamespace";
    }

    private static String nugetPackageIdPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".nuget.packageId";
    }

    private static String nugetPackageVersionPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".nuget.packageVersion";
    }

    private static String escapeXml(String str) {
        return str.replace("&", "&amp;").replace("\"", "&quot;").replace("'", "&apos;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static void appendLine(Writer writer, String line) {
        try {
            writer.write(line);
            writer.write("\r\n");
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

