/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.plugins.csharp.Zip;

@InstantiationStrategy(value="PER_BATCH")
public class RuleRunnerExtractor
implements BatchExtension {
    private static final String RULE_RUNNER = "SonarLint.Runner";
    private static final String RULE_RUNNER_ZIP = "SonarLint.Runner.zip";
    private static final String RULE_RUNNER_EXE = "SonarLint.Runner.exe";
    private final ProjectReactor reactor;
    private File file = null;

    public RuleRunnerExtractor(ProjectReactor reactor) {
        this.reactor = reactor;
    }

    public File executableFile() {
        if (this.file == null) {
            this.file = this.unzipRuleRunner();
        }
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unzipRuleRunner() {
        File workingDir = this.reactor.getRoot().getWorkDir();
        File toolWorkingDir = new File(workingDir, RULE_RUNNER);
        File zipFile = new File(workingDir, RULE_RUNNER_ZIP);
        try {
            Files.createParentDirs((File)zipFile);
            try (InputStream is = this.getClass().getResourceAsStream("/SonarLint.Runner.zip");){
                Files.write((byte[])ByteStreams.toByteArray((InputStream)is), (File)zipFile);
            }
            new Zip(zipFile).unzip(toolWorkingDir);
            return new File(toolWorkingDir, RULE_RUNNER_EXE);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

