/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.plugins.csharp.CSharpSonarRulesDefinition;

public class SonarLintProfileExporter
extends ProfileExporter {
    private final CSharpSonarRulesDefinition csharpRulesDefinition;

    public SonarLintProfileExporter(CSharpSonarRulesDefinition csharpRulesDefinition) {
        super("sonarlint-vs-cs", "SonarLint for Visual Studio Rule Set");
        this.setSupportedLanguages(new String[]{"cs"});
        this.csharpRulesDefinition = csharpRulesDefinition;
    }

    public void exportProfile(RulesProfile ruleProfile, Writer writer) {
        HashSet disabledRuleKeys = Sets.newHashSet();
        disabledRuleKeys.addAll(this.csharpRulesDefinition.allRuleKeys());
        SonarLintProfileExporter.appendLine(writer, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        SonarLintProfileExporter.appendLine(writer, "<RuleSet Name=\"Rules for SonarLint\" Description=\"This rule set was automatically generated from SonarQube.\" ToolsVersion=\"14.0\">");
        SonarLintProfileExporter.appendLine(writer, "  <Rules AnalyzerId=\"SonarAnalyzer.CSharp\" RuleNamespace=\"SonarAnalyzer.CSharp\">");
        for (ActiveRule activeRule : ruleProfile.getActiveRulesByRepository("csharpsquid")) {
            Rule rule = activeRule.getRule();
            disabledRuleKeys.remove(rule.getKey());
            SonarLintProfileExporter.appendLine(writer, "    <Rule Id=\"" + rule.getKey() + "\" Action=\"Warning\" />");
        }
        for (String disableRuleKey : disabledRuleKeys) {
            SonarLintProfileExporter.appendLine(writer, "    <Rule Id=\"" + disableRuleKey + "\" Action=\"None\" />");
        }
        SonarLintProfileExporter.appendLine(writer, "  </Rules>");
        SonarLintProfileExporter.appendLine(writer, "</RuleSet>");
    }

    private static void appendLine(Writer writer, String line) {
        try {
            writer.write(line);
            writer.write("\r\n");
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

