/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.FileService;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;
import org.sonarsource.dotnet.shared.CallableUtils;

@Deprecated
public class NCover3ReportParser
implements CoverageParser {
    private static final String EXCLUDED_ID = "0";
    private static final Logger LOG = LoggerFactory.getLogger(NCover3ReportParser.class);
    private final FileService fileService;
    private final AnalysisWarnings analysisWarnings;

    NCover3ReportParser(FileService fileService, AnalysisWarnings analysisWarnings) {
        this.fileService = fileService;
        this.analysisWarnings = analysisWarnings;
    }

    @Override
    public void accept(File file, Coverage coverage) {
        LOG.debug("The current user dir is '{}'.", CallableUtils.lazy(() -> System.getProperty("user.dir")));
        LOG.info("Parsing the NCover3 report {}", (Object)file.getAbsolutePath());
        new Parser(file, coverage).parse();
    }

    private class Parser {
        private final File file;
        private final Map<String, String> documents = new HashMap<String, String>();
        private final Coverage coverage;

        Parser(File file, Coverage coverage) {
            this.file = file;
            this.coverage = coverage;
        }

        public void parse() {
            String deprecationMessage = "NCover3 coverage import is deprecated since version 8.6 of the plugin. Consider using a different code coverage tool instead.";
            LOG.warn(deprecationMessage);
            NCover3ReportParser.this.analysisWarnings.addUnique(deprecationMessage);
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                this.checkRootTag(xmlParserHelper);
                this.dispatchTags(xmlParserHelper);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void dispatchTags(XmlParserHelper xmlParserHelper) {
            String tagName;
            while ((tagName = xmlParserHelper.nextStartTag()) != null) {
                if ("doc".equals(tagName)) {
                    this.handleDocTag(xmlParserHelper);
                    continue;
                }
                if (!"seqpnt".equals(tagName)) continue;
                this.handleSegmentPointTag(xmlParserHelper);
            }
        }

        private void handleDocTag(XmlParserHelper xmlParserHelper) {
            String id = xmlParserHelper.getRequiredAttribute("id");
            String url = xmlParserHelper.getRequiredAttribute("url");
            LOG.trace("Analyzing the doc tag with NCover3 ID '{}' and url '{}'.", (Object)id, (Object)url);
            if (!this.isExcludedId(id)) {
                try {
                    String path = new File(url).getCanonicalPath();
                    LOG.trace("NCover3 ID '{}' with url '{}' is resolved as '{}'.", new Object[]{id, url, path});
                    this.documents.put(id, path);
                }
                catch (IOException e) {
                    LOG.debug("Skipping the import of NCover3 code coverage for the invalid file path: " + url + " at line " + xmlParserHelper.stream().getLocation().getLineNumber(), (Throwable)e);
                }
            } else {
                LOG.debug("NCover3 ID '{}' is excluded, so url '{}' was not added.", (Object)id, (Object)url);
            }
        }

        private boolean isExcludedId(String id) {
            return NCover3ReportParser.EXCLUDED_ID.equals(id);
        }

        private void handleSegmentPointTag(XmlParserHelper xmlParserHelper) {
            String doc = xmlParserHelper.getRequiredAttribute("doc");
            int line = xmlParserHelper.getRequiredIntAttribute("l");
            int vc = xmlParserHelper.getRequiredIntAttribute("vc");
            if (this.documents.containsKey(doc) && !this.isExcludedLine(line)) {
                String path = this.documents.get(doc);
                if (NCover3ReportParser.this.fileService.isSupportedAbsolute(path)) {
                    LOG.trace("Found coverage for line '{}', vc '{}' when analyzing the doc '{}' with the path '{}'.", new Object[]{line, vc, doc, path});
                    this.coverage.addHits(path, line, vc);
                } else {
                    LOG.debug("NCover3 doc '{}', line '{}', vc '{}' will be skipped because it has a path '{}' which is not indexed or does not have the supported language. Verify sonar.sources in .sonarqube\\out\\sonar-project.properties.", new Object[]{doc, line, vc, path});
                }
            } else if (!this.isExcludedLine(line)) {
                LOG.debug("NCover3 doc '{}' is not contained in documents and will be skipped.", (Object)doc);
            }
        }

        private boolean isExcludedLine(Integer line) {
            return 0 == line;
        }

        private void checkRootTag(XmlParserHelper xmlParserHelper) {
            xmlParserHelper.checkRootTag("coverage");
            xmlParserHelper.checkRequiredAttribute("exportversion", 3);
        }
    }
}

