/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.dotnet.tests.NUnitTestResultsFileParser;
import org.sonar.plugins.dotnet.tests.UnitTestConfiguration;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsParser;
import org.sonar.plugins.dotnet.tests.VisualStudioTestResultsFileParser;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;
import org.sonar.plugins.dotnet.tests.XUnitTestResultsFileParser;

@ScannerSide
public class UnitTestResultsAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(UnitTestResultsAggregator.class);
    private final UnitTestConfiguration unitTestConf;
    private final Configuration configuration;
    private final VisualStudioTestResultsFileParser visualStudioTestResultsFileParser;
    private final NUnitTestResultsFileParser nunitTestResultsFileParser;
    private final XUnitTestResultsFileParser xunitTestResultsFileParser;

    public UnitTestResultsAggregator(UnitTestConfiguration unitTestConf, Configuration configuration) {
        this(unitTestConf, configuration, new VisualStudioTestResultsFileParser(), new NUnitTestResultsFileParser(), new XUnitTestResultsFileParser());
    }

    UnitTestResultsAggregator(UnitTestConfiguration unitTestConf, Configuration configuration, VisualStudioTestResultsFileParser visualStudioTestResultsFileParser, NUnitTestResultsFileParser nunitTestResultsFileParser, XUnitTestResultsFileParser xunitTestResultsFileParser) {
        this.unitTestConf = unitTestConf;
        this.configuration = configuration;
        this.visualStudioTestResultsFileParser = visualStudioTestResultsFileParser;
        this.nunitTestResultsFileParser = nunitTestResultsFileParser;
        this.xunitTestResultsFileParser = xunitTestResultsFileParser;
    }

    boolean hasUnitTestResultsProperty(Predicate<String> hasKeyPredicate) {
        return this.hasVisualStudioTestResultsFile(hasKeyPredicate) || this.hasNUnitTestResultsFile(hasKeyPredicate) || this.hasXUnitTestResultsFile(hasKeyPredicate);
    }

    boolean hasUnitTestResultsProperty() {
        return this.hasUnitTestResultsProperty(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0));
    }

    private boolean hasVisualStudioTestResultsFile(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.unitTestConf.visualStudioTestResultsFilePropertyKey());
    }

    private boolean hasNUnitTestResultsFile(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.unitTestConf.nunitTestResultsFilePropertyKey());
    }

    private boolean hasXUnitTestResultsFile(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.unitTestConf.xunitTestResultsFilePropertyKey());
    }

    UnitTestResults aggregate(WildcardPatternFileProvider wildcardPatternFileProvider) {
        UnitTestResults results = new UnitTestResults();
        if (this.hasVisualStudioTestResultsFile(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            UnitTestResultsAggregator.aggregate(wildcardPatternFileProvider, this.configuration.getStringArray(this.unitTestConf.visualStudioTestResultsFilePropertyKey()), this.visualStudioTestResultsFileParser, results);
        }
        if (this.hasNUnitTestResultsFile(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            UnitTestResultsAggregator.aggregate(wildcardPatternFileProvider, this.configuration.getStringArray(this.unitTestConf.nunitTestResultsFilePropertyKey()), this.nunitTestResultsFileParser, results);
        }
        if (this.hasXUnitTestResultsFile(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            UnitTestResultsAggregator.aggregate(wildcardPatternFileProvider, this.configuration.getStringArray(this.unitTestConf.xunitTestResultsFilePropertyKey()), this.xunitTestResultsFileParser, results);
        }
        return results;
    }

    private static void aggregate(WildcardPatternFileProvider wildcardPatternFileProvider, String[] reportPaths, UnitTestResultsParser parser, UnitTestResults unitTestResults) {
        for (String reportPathPattern : reportPaths) {
            if (reportPathPattern.isEmpty()) continue;
            for (File reportFile : wildcardPatternFileProvider.listFiles(reportPathPattern)) {
                try {
                    parser.accept(reportFile, unitTestResults);
                }
                catch (Exception e) {
                    LOG.warn("Could not import unit test report '{}': {}", (Object)reportFile, (Object)e.getMessage());
                }
            }
        }
    }
}

