/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.config.Configuration;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

@ScannerSide
public abstract class AbstractLanguageConfiguration {
    protected final PluginMetadata metadata;
    protected final Configuration configuration;

    protected AbstractLanguageConfiguration(Configuration configuration, PluginMetadata metadata) {
        this.configuration = configuration;
        this.metadata = metadata;
    }

    public boolean ignoreThirdPartyIssues() {
        return this.configuration.getBoolean(AbstractPropertyDefinitions.getIgnoreIssuesProperty(this.metadata.languageKey())).orElse(false);
    }

    public Set<String> bugCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getBugCategoriesProperty(this.metadata.languageKey()))));
    }

    public Set<String> codeSmellCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getCodeSmellCategoriesProperty(this.metadata.languageKey()))));
    }

    public Set<String> vulnerabilityCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getVulnerabilityCategoriesProperty(this.metadata.languageKey()))));
    }

    public boolean analyzeGeneratedCode() {
        return this.configuration.getBoolean(AbstractPropertyDefinitions.getAnalyzeGeneratedCode(this.metadata.languageKey())).orElse(false);
    }
}

