/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

public abstract class AbstractPropertyDefinitions {
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";
    protected static final String PROP_PREFIX = "sonar.";
    public static final String PROJECT_KEY_PROPERTY = "sonar.projectKey";
    public static final String PROJECT_NAME_PROPERTY = "sonar.projectName";
    public static final String PROJECT_BASE_DIR_PROPERTY = "sonar.projectBaseDir";
    protected final PluginMetadata metadata;

    protected AbstractPropertyDefinitions(PluginMetadata metadata) {
        this.metadata = metadata;
    }

    public List<PropertyDefinition> create() {
        String languageKey = this.metadata.languageKey();
        String languageName = this.metadata.languageName();
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getRoslynJsonReportPathProperty(this.metadata.languageKey())).multiValues(true).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(languageKey)).multiValues(true).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getFileSuffixProperty(languageKey)).category(languageName).defaultValue(this.metadata.fileSuffixesDefaultValue()).name("File suffixes").description("List of suffixes for files to analyze.").multiValues(true).onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getIgnoreHeaderCommentsProperty(languageKey)).category(languageName).defaultValue("true").name("Ignore header comments").description("If set to \"true\", the file headers (that are usually the same on each file: licensing information for example) are not considered as comments. Thus metrics such as \"Comment lines\" do not get incremented. If set to \"false\", those file headers are considered as comments and metrics such as \"Comment lines\" get incremented.").onQualifiers("TRK", new String[0]).type(PropertyType.BOOLEAN).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getAnalyzeGeneratedCode(languageKey)).category(languageName).defaultValue("false").name("Analyze generated code").description("If set to \"true\", the files containing generated code are analyzed. If set to \"false\", the files containing generated code are ignored.").onQualifiers("TRK", new String[0]).type(PropertyType.BOOLEAN).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getIgnoreIssuesProperty(languageKey)).type(PropertyType.BOOLEAN).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(languageName).index(0).defaultValue("false").name("Ignore issues from external Roslyn analyzers").description("If set to 'true', issues reported by external Roslyn analyzers won't be imported.").onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getBugCategoriesProperty(languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(languageName).index(1).name("Rule categories associated with Bugs").description("External rule categories to be treated as Bugs.").onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getVulnerabilityCategoriesProperty(languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(languageName).index(2).name("Rule categories associated with Vulnerabilities").description("External rule categories to be treated as Vulnerabilities.").onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getCodeSmellCategoriesProperty(languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(languageName).index(3).name("Rule categories associated with Code Smells").description("External rule categories to be treated as Code Smells. By default, external issues are Code Smells, or Bugs when the severity is error.").onQualifiers("TRK", new String[0]).build());
        return result;
    }

    public static String getIgnoreHeaderCommentsProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".ignoreHeaderComments";
    }

    public static String getAnalyzeGeneratedCode(String languageKey) {
        return PROP_PREFIX + languageKey + ".analyzeGeneratedCode";
    }

    public static String getFileSuffixProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".file.suffixes";
    }

    public static String getRoslynJsonReportPathProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.reportFilePaths";
    }

    public static String getAnalyzerWorkDirProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".analyzer.projectOutPaths";
    }

    public static String getIgnoreIssuesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.ignoreIssues";
    }

    public static String getBugCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.bugCategories";
    }

    public static String getCodeSmellCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.codeSmellCategories";
    }

    public static String getVulnerabilityCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.vulnerabilityCategories";
    }

    public static String getPullRequestCacheBasePath() {
        return "sonar.pullrequest.cache.basepath";
    }

    public static String getPullRequestBase() {
        return "sonar.pullrequest.base";
    }
}

