/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.dotnet.tests.CoverageAggregator;
import org.sonar.plugins.dotnet.tests.CoverageConfiguration;
import org.sonar.plugins.dotnet.tests.CoverageReportImportSensor;
import org.sonar.plugins.dotnet.tests.ScannerFileService;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

@ScannerSide
public class CodeCoverageProvider {
    private static final String SUBCATEGORY = "Code Coverage";
    private static final String SONAR_PROPERTY_PREFIX = "sonar.";
    private final PluginMetadata pluginMetadata;
    private final CoverageConfiguration coverageConf;

    public CodeCoverageProvider(PluginMetadata pluginMetadata) {
        this.pluginMetadata = pluginMetadata;
        String languageKey = pluginMetadata.languageKey();
        this.coverageConf = new CoverageConfiguration(languageKey, SONAR_PROPERTY_PREFIX + languageKey + ".ncover3.reportsPaths", SONAR_PROPERTY_PREFIX + languageKey + ".opencover.reportsPaths", SONAR_PROPERTY_PREFIX + languageKey + ".dotcover.reportsPaths", SONAR_PROPERTY_PREFIX + languageKey + ".vscoveragexml.reportsPaths");
    }

    public List<Object> extensions() {
        String category = this.pluginMetadata.languageName();
        return Arrays.asList(this, UnitTestCoverageAggregator.class, UnitTestCoverageReportImportSensor.class, PropertyDefinition.builder((String)this.coverageConf.ncover3PropertyKey()).name("NCover3 Unit Tests Reports Paths").description("Example: \"report.nccov\", \"report1.nccov,report2.nccov\" or \"C:/report.nccov\"").category(category).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[0]).multiValues(true).build(), PropertyDefinition.builder((String)this.coverageConf.openCoverPropertyKey()).name("OpenCover Unit Tests Reports Paths").description("Example: \"report.xml\", \"report1.xml,report2.xml\" or \"C:/report.xml\"").category(category).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[0]).multiValues(true).build(), PropertyDefinition.builder((String)this.coverageConf.dotCoverPropertyKey()).name("dotCover Unit Tests (HTML) Reports Paths").description("Example: \"report.html\", \"report1.html,report2.html\" or \"C:/report.html\"").category(category).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[0]).multiValues(true).build(), PropertyDefinition.builder((String)this.coverageConf.visualStudioCoverageXmlPropertyKey()).name("Visual Studio Unit Tests (XML) Reports Paths").description("Example: \"report.coveragexml\", \"report1.coveragexml,report2.coveragexml\" or \"C:/report.coveragexml\"").category(category).subCategory(SUBCATEGORY).onlyOnQualifiers("TRK", new String[0]).multiValues(true).build());
    }

    public class UnitTestCoverageAggregator
    extends CoverageAggregator {
        public UnitTestCoverageAggregator(Configuration configuration, FileSystem fileSystem, AnalysisWarnings analysisWarnings) {
            super(CodeCoverageProvider.this.coverageConf, configuration, new ScannerFileService(CodeCoverageProvider.this.coverageConf.languageKey(), fileSystem), analysisWarnings);
        }
    }

    public class UnitTestCoverageReportImportSensor
    extends CoverageReportImportSensor {
        public UnitTestCoverageReportImportSensor(UnitTestCoverageAggregator coverageAggregator) {
            super(CodeCoverageProvider.this.coverageConf, coverageAggregator, CodeCoverageProvider.this.pluginMetadata.languageKey(), CodeCoverageProvider.this.pluginMetadata.languageName());
        }
    }
}

