/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonarsource.dotnet.shared.plugins.AbstractLanguageConfiguration;
import org.sonarsource.dotnet.shared.plugins.GlobalProtobufFileProcessor;

public class GeneratedFileFilter
implements InputFileFilter {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratedFileFilter.class);
    private final GlobalProtobufFileProcessor globalReportProcessor;
    private final boolean analyzeGeneratedCode;

    public GeneratedFileFilter(GlobalProtobufFileProcessor globalReportProcessor, AbstractLanguageConfiguration configuration) {
        this.globalReportProcessor = globalReportProcessor;
        this.analyzeGeneratedCode = configuration.analyzeGeneratedCode();
        if (this.analyzeGeneratedCode) {
            LOG.debug("Will analyze generated code");
        } else {
            LOG.debug("Will ignore generated code");
        }
    }

    public boolean accept(InputFile inputFile) {
        if (this.analyzeGeneratedCode) {
            return true;
        }
        boolean isGenerated = this.globalReportProcessor.isGenerated(inputFile);
        if (isGenerated) {
            LOG.debug("Skipping auto generated file: {}", (Object)inputFile);
        }
        return !isGenerated;
    }
}

