/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Path;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonarsource.dotnet.shared.plugins.ModuleConfiguration;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.ProtobufDataImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.LogImporter;

public class LogSensor
implements Sensor {
    private final PluginMetadata pluginMetadata;
    private final ModuleConfiguration configuration;

    public LogSensor(PluginMetadata pluginMetadata, ModuleConfiguration configuration) {
        this.pluginMetadata = pluginMetadata;
        this.configuration = configuration;
    }

    public void describe(SensorDescriptor descriptor) {
        String name = String.format("%s Analysis Log", this.pluginMetadata.languageName());
        descriptor.name(name);
    }

    public void execute(SensorContext context) {
        LogImporter importer = new LogImporter();
        for (Path protobufDir : this.configuration.protobufReportPaths()) {
            ProtobufDataImporter.parseProtobuf(importer, protobufDir, "log.pb");
            importer.save();
        }
    }
}

