/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@BatchSide
@ScannerSide
public abstract class AbstractConfiguration {
    private static final Logger LOG = Loggers.get(AbstractConfiguration.class);
    private final Settings settings;
    private Boolean reportsComingFromMSBuild;

    public AbstractConfiguration(Settings settings) {
        this.settings = settings;
    }

    public abstract String getRoslynJsonReportPathProperty();

    public abstract String getAnalyzerWorkDirProperty();

    public abstract String getAnalyzerReportDir();

    public boolean isReportsComingFromMSBuild() {
        if (this.reportsComingFromMSBuild == null) {
            this.reportsComingFromMSBuild = this.areProtobufReportsPresent();
        }
        return this.reportsComingFromMSBuild;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areProtobufReportsPresent() {
        if (!this.settings.hasKey(this.getAnalyzerWorkDirProperty())) {
            return false;
        }
        Path analyzerOutputDir = this.protobufReportPathFromScanner();
        if (!analyzerOutputDir.toFile().exists()) {
            LOG.info("Analyzer working directory does not exist");
            return false;
        }
        try (DirectoryStream<Path> files = Files.newDirectoryStream(analyzerOutputDir, p -> p.toAbsolutePath().toString().toLowerCase().endsWith(".pb"));){
            long count = StreamSupport.stream(files.spliterator(), false).count();
            LOG.info("Analyzer working directory contains " + count + " .pb file(s)");
            boolean bl = count != 0L;
            return bl;
        }
        catch (IOException e) {
            LOG.warn("Could not check for .pb files in " + analyzerOutputDir.toAbsolutePath().toString(), (Throwable)e);
            return false;
        }
    }

    public Path protobufReportPathFromScanner() {
        String analyzerWorkDirPath = this.settings.getString(this.getAnalyzerWorkDirProperty());
        return Paths.get(analyzerWorkDirPath, this.getAnalyzerReportDir());
    }
}

