/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractConfiguration;
import org.sonarsource.dotnet.shared.plugins.EncodingPerFile;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporters;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;
import org.sonarsource.dotnet.shared.sarif.Location;
import org.sonarsource.dotnet.shared.sarif.SarifParserCallback;

public abstract class AbstractSensor {
    private static final Logger LOG = Loggers.get(AbstractSensor.class);
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final EncodingPerFile encodingPerFile;
    private final AbstractConfiguration config;
    private final String repositoryKey;

    protected AbstractSensor(FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, AbstractConfiguration config, EncodingPerFile encodingPerFile, String repositoryKey) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.config = config;
        this.encodingPerFile = encodingPerFile;
        this.repositoryKey = repositoryKey;
    }

    public void importResults(SensorContext context, Path protobufReportsDirectory, boolean importIssues) {
        Predicate<InputFile> inputFileFilter;
        if (!this.config.isReportsComingFromMSBuild()) {
            this.encodingPerFile.init(protobufReportsDirectory);
            inputFileFilter = this.encodingPerFile::encodingMatch;
        } else {
            inputFileFilter = f -> true;
        }
        AbstractSensor.parseProtobuf(ProtobufImporters.metricsImporter(context, this.fileLinesContextFactory, this.noSonarFilter, inputFileFilter), protobufReportsDirectory, "metrics.pb");
        if (importIssues) {
            AbstractSensor.parseProtobuf(ProtobufImporters.issuesImporter(context, this.repositoryKey, inputFileFilter), protobufReportsDirectory, "issues.pb");
        }
        AbstractSensor.parseProtobuf(ProtobufImporters.highlightImporter(context, inputFileFilter), protobufReportsDirectory, "token-type.pb");
        AbstractSensor.parseProtobuf(ProtobufImporters.symbolRefsImporter(context, inputFileFilter), protobufReportsDirectory, "symrefs.pb");
        AbstractSensor.parseProtobuf(ProtobufImporters.cpdTokensImporter(context, inputFileFilter), protobufReportsDirectory, "token-cpd.pb");
    }

    private static void parseProtobuf(RawProtobufImporter<?> importer, Path workDirectory, String filename) {
        Path protobuf = workDirectory.resolve(filename);
        if (protobuf.toFile().exists()) {
            importer.accept(protobuf);
        } else {
            LOG.warn("Protobuf file not found: " + protobuf);
        }
    }

    public static class LogErrorStreamConsumer
    implements StreamConsumer {
        public void consumeLine(String line) {
            LOG.error(line);
        }
    }

    public static class LogInfoStreamConsumer
    implements StreamConsumer {
        public void consumeLine(String line) {
            LOG.info(line);
        }
    }

    protected static final class SarifParserCallbackImplementation
    implements SarifParserCallback {
        private final SensorContext context;
        private final Map<String, String> repositoryKeyByRoslynRuleKey;

        public SarifParserCallbackImplementation(SensorContext context, Map<String, String> repositoryKeyByRoslynRuleKey) {
            this.context = context;
            this.repositoryKeyByRoslynRuleKey = repositoryKeyByRoslynRuleKey;
        }

        @Override
        public void onProjectIssue(String ruleId, String message) {
            String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
            if (repositoryKey == null) {
                return;
            }
            NewIssue newIssue = this.context.newIssue();
            newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)this.context.module()).message(message)).save();
        }

        @Override
        public void onFileIssue(String ruleId, String absolutePath, String message) {
            String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
            if (repositoryKey == null) {
                return;
            }
            InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(absolutePath));
            if (inputFile == null) {
                return;
            }
            NewIssue newIssue = this.context.newIssue();
            newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)inputFile).message(message)).save();
        }

        @Override
        public void onIssue(String ruleId, Location primaryLocation, Collection<Location> secondaryLocations) {
            String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
            if (repositoryKey == null) {
                return;
            }
            InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(primaryLocation.getAbsolutePath()));
            if (inputFile == null) {
                return;
            }
            NewIssue newIssue = this.context.newIssue();
            newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)inputFile).at(inputFile.newRange(primaryLocation.getStartLine(), primaryLocation.getStartColumn(), primaryLocation.getEndLine(), primaryLocation.getEndColumn())).message(primaryLocation.getMessage()));
            for (Location secondaryLocation : secondaryLocations) {
                if (!inputFile.absolutePath().equalsIgnoreCase(secondaryLocation.getAbsolutePath()) && (inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(secondaryLocation.getAbsolutePath()))) == null) {
                    return;
                }
                NewIssueLocation newIssueLocation = newIssue.newLocation().on((InputComponent)inputFile).at(inputFile.newRange(secondaryLocation.getStartLine(), secondaryLocation.getStartColumn(), secondaryLocation.getEndLine(), secondaryLocation.getEndColumn()));
                String secondaryLocationMessage = secondaryLocation.getMessage();
                if (secondaryLocationMessage != null) {
                    newIssueLocation.message(secondaryLocationMessage);
                }
                newIssue.addLocation(newIssueLocation);
            }
            newIssue.save();
        }
    }
}

